/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String DEFAULT_APPLICATION_FOLDER = "src/main/application";
    private static final String EAR_SOURCE_DIRECTORY_KEY = "earSourceDirectory";
    private static final String EAR_VERSION = "version";
    private static final String GENERATE_APPLICATION_XML = "generateApplicationXml";
    private static final Logger LOG = LoggerFactory.getLogger(EarProjectConverter.class);

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"ear".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setEarPlugin(component, model);
    }

    private void setEarPlugin(IVirtualComponent component, Model model) throws CoreException {
        Build build = this.getCloneOrCreateBuild(model);
        String pluginVersion = this.getEarPluginVersion();
        Plugin earPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-ear-plugin", pluginVersion);
        IFolder applicationContentFolder = this.findEarContentFolder(component);
        boolean hasApplicationXml = true;
        boolean customized = false;
        IProject project = component.getProject();
        if (applicationContentFolder != null) {
            String applicationContent = applicationContentFolder.getProjectRelativePath().toPortableString();
            if (!DEFAULT_APPLICATION_FOLDER.equals(applicationContent)) {
                MavenPluginUtils.configure(earPlugin, EAR_SOURCE_DIRECTORY_KEY, applicationContent);
                customized = true;
            }
            hasApplicationXml = applicationContentFolder.getFile("META-INF/application.xml").exists();
        } else {
            String msg = NLS.bind((String)Messages.EarProjectConverter_Error_EAR_Root_Content_Folder, (Object)(project != null ? project.getName() : component.getName()));
            String description = model.getDescription();
            String warning = "!!!EAR resources from the root directory need to be moved under src/main/application!!!";
            description = StringUtils.isNotEmpty((String)description) ? String.valueOf(description) + "\n" + warning : warning;
            model.setDescription(description);
            LOG.warn(msg);
        }
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)component.getProject());
        if (fProject != null) {
            String libDir;
            IProjectFacetVersion earVersion = fProject.getProjectFacetVersion(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET);
            if (!IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13.equals(earVersion)) {
                String version;
                boolean isJavaEE;
                boolean bl = isJavaEE = earVersion.compareTo((Object)IJ2EEFacetConstants.ENTERPRISE_APPLICATION_50) >= 0;
                if (isJavaEE) {
                    version = earVersion.getVersionString().substring(0, 1);
                    if (!hasApplicationXml) {
                        MavenPluginUtils.configure(earPlugin, GENERATE_APPLICATION_XML, "false");
                    }
                } else {
                    version = earVersion.getVersionString();
                }
                MavenPluginUtils.configure(earPlugin, EAR_VERSION, version);
                customized = true;
            }
            if ((libDir = EarUtilities.getEARLibDir((IVirtualComponent)component)) == null) {
                IProject libDirContainer = applicationContentFolder == null ? project : applicationContentFolder;
                libDir = this.inspectDefaultLibDirs((IContainer)libDirContainer);
            }
            if (libDir != null) {
                MavenPluginUtils.configure(earPlugin, "defaultLibBundleDir", libDir);
                customized = true;
            }
        }
        if (customized) {
            model.setBuild(build);
        }
    }

    private String inspectDefaultLibDirs(IContainer applicationContentFolder) {
        String[] stringArray = new String[]{"lib", "APP-INF/lib"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (applicationContentFolder.getFolder((IPath)new Path(candidate)).exists()) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private IFolder findEarContentFolder(IVirtualComponent component) {
        return WTPProjectsUtil.getDefaultDeploymentDescriptorFolder(component.getRootFolder());
    }

    @Override
    protected IProjectFacet getRequiredFaced() {
        return WTPProjectsUtil.EAR_FACET;
    }

    private String getEarPluginVersion() {
        String version = System.getProperty("org.eclipse.m2e.wtp.conversion.earplugin.version");
        if (version != null) {
            return version;
        }
        return MavenPluginUtils.getMostRecentPluginVersion("org.apache.maven.plugins", "maven-ear-plugin", "3.0.0");
    }
}

