/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jpa.internal.configurators;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.model.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.resource.ModuleResourceLocator;
import org.eclipse.jpt.common.core.internal.resource.SimpleJavaResourceLocator;
import org.eclipse.jpt.common.core.internal.resource.WebModuleResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class MavenResourceLocator
implements ResourceLocator {
    private static IPath META_INF_PATH = new Path("META-INF");
    private static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");

    public boolean resourceLocationIsValid(IProject project, IContainer container) {
        IMavenProjectFacade mavenProjectFacade = this.getMavenProjectFacade(project);
        boolean accept = true;
        if (mavenProjectFacade != null && mavenProjectFacade.getMavenProject() != null) {
            IPath classesPath = mavenProjectFacade.getOutputLocation();
            IPath testClassesPath = mavenProjectFacade.getTestOutputLocation();
            if (classesPath.isPrefixOf(container.getFullPath()) || testClassesPath.isPrefixOf(container.getFullPath())) {
                accept = false;
            }
        } else {
            accept = MavenResourceLocator.isResourceLocationValid(this.getDelegate(project), project, container);
        }
        return accept;
    }

    private ResourceLocator getDelegate(IProject project) {
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && facetedProject.hasProjectFacet(WEB_FACET)) {
                    return new WebModuleResourceLocator();
                }
            }
            catch (CoreException coreException) {}
            return new ModuleResourceLocator();
        }
        return new SimpleJavaResourceLocator();
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        IPath resourcePath = null;
        IMavenProjectFacade mavenProjectFacade = this.getMavenProjectFacade(project);
        if (mavenProjectFacade != null && mavenProjectFacade.getMavenProject() != null) {
            List resources = mavenProjectFacade.getMavenProject().getBuild().getResources();
            for (Resource resourceFolder : resources) {
                resourcePath = this.getFilePath(this.getWorkspaceRelativePath(resourceFolder), runtimePath);
                if (resourcePath == null) {
                    continue;
                }
                break;
            }
        } else {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (3 == entry.getEntryKind() && (resourcePath = this.getFilePath(entry.getPath(), runtimePath)) != null) break;
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        if (resourcePath == null) {
            resourcePath = this.getDelegate(project).getResourcePath(project, runtimePath);
        }
        return resourcePath;
    }

    private IPath getFilePath(IPath containerPath, IPath runtimePath) {
        IWorkspaceRoot root;
        IFile resource;
        if (containerPath != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).getFile(containerPath.append(runtimePath))).exists()) {
            return resource.getFullPath();
        }
        return null;
    }

    public IContainer getDefaultResourceLocation(IProject project) {
        IMavenProjectFacade mavenProjectFacade = this.getMavenProjectFacade(project);
        IContainer defaultLocation = null;
        if (mavenProjectFacade != null && mavenProjectFacade.getMavenProject() != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (Resource resourceFolder : mavenProjectFacade.getMavenProject().getBuild().getResources()) {
                IPath p = this.getWorkspaceRelativePath(resourceFolder);
                if (p == null) continue;
                IFolder candidate = root.getFolder(p.append(META_INF_PATH));
                if (candidate.exists()) {
                    return candidate;
                }
                if (defaultLocation != null) continue;
                defaultLocation = candidate;
            }
        }
        if (defaultLocation == null) {
            defaultLocation = this.getDelegate(project).getDefaultResourceLocation(project);
        }
        return defaultLocation;
    }

    private IPath getWorkspaceRelativePath(Resource mavenResourceFolder) {
        File resourceDirectory = new File(mavenResourceFolder.getDirectory());
        IPath relativePath = null;
        if (resourceDirectory.exists() && resourceDirectory.isDirectory()) {
            relativePath = this.getWorkspaceRelativePath(mavenResourceFolder.getDirectory());
        }
        return relativePath;
    }

    private IPath getWorkspaceRelativePath(String absolutePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath relativePath = new Path(absolutePath).makeRelativeTo(root.getLocation());
        return relativePath;
    }

    private IMavenProjectFacade getMavenProjectFacade(IProject project) {
        return MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IPath runtimePath = this.getDelegate(project).getRuntimePath(project, resourcePath);
        return runtimePath;
    }

    @Deprecated
    public boolean acceptResourceLocation(IProject project, IContainer container) {
        return this.resourceLocationIsValid(project, container);
    }

    private static boolean isResourceLocationValid(ResourceLocator resourceLocator, IProject project, IContainer container) {
        Method isResourceLocationIsValid = null;
        Method[] methodArray = resourceLocator.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if ("isResourceLocationIsValid".equals(m.getName()) || "acceptResourceLocation".equals(m.getName())) {
                isResourceLocationIsValid = m;
                break;
            }
            ++n2;
        }
        boolean result = false;
        if (isResourceLocationIsValid != null) {
            try {
                result = (Boolean)isResourceLocationIsValid.invoke((Object)resourceLocator, project, container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

