/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jpa.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.common.core.JptWorkspace;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocatorManager;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JptUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JptUtils.class);

    public static IFile getPersistenceXml(IProject project) {
        ResourceLocator resourceLocator = JptUtils.getResourceLocator(project);
        if (resourceLocator == null) {
            return null;
        }
        IPath path = resourceLocator.getWorkspacePath(project, (IPath)new Path("META-INF/persistence.xml"));
        IFile persistenceXml = null;
        if (path != null) {
            persistenceXml = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return persistenceXml;
    }

    public static XmlPersistenceUnit getFirstXmlPersistenceUnit(JptXmlResource persistenceXml) {
        XmlPersistence xmlPersistence;
        EList persistenceUnits;
        if (persistenceXml != null && persistenceXml.getRootObject() instanceof XmlPersistence && (persistenceUnits = (xmlPersistence = (XmlPersistence)persistenceXml.getRootObject()).getPersistenceUnits()) != null && !persistenceUnits.isEmpty()) {
            return (XmlPersistenceUnit)persistenceUnits.get(0);
        }
        return null;
    }

    public static IProjectFacetVersion getVersion(JptXmlResource persistenceXml) {
        if (persistenceXml == null) {
            return null;
        }
        String version = persistenceXml.getVersion();
        if (version != null && version.trim().length() > 0) {
            try {
                return JpaProject.FACET.getVersion(version);
            }
            catch (Exception e) {
                LOG.error("Can not get JPA Facet version " + version, (Throwable)e);
                try {
                    return JpaProject.FACET.getLatestVersion();
                }
                catch (CoreException cex) {
                    LOG.error("Can not get Latest JPA Facet version", (Throwable)cex);
                }
            }
        }
        return JpaProject.FACET.getDefaultVersion();
    }

    public static ResourceLocator getResourceLocator(IProject project) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        JptWorkspace jptWorkspace = (JptWorkspace)workspace.getAdapter(JptWorkspace.class);
        ResourceLocatorManager rlm = jptWorkspace.getResourceLocatorManager();
        return rlm == null ? null : rlm.getResourceLocator(project);
    }
}

