/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.JDTTypeResolver;
import org.eclipse.jst.jsf.common.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTBeanPropertyWorkingCopy {
    private final List<IMethod> setters = new ArrayList<IMethod>();
    private IMethod isGetter;
    private IMethod getter;
    private final IType type;
    private final JDTTypeResolver typeResolver;
    private final String propertyName;

    public JDTBeanPropertyWorkingCopy(IType type, JDTTypeResolver typeResolver, String propertyName) {
        this.type = type;
        this.typeResolver = typeResolver;
        this.propertyName = propertyName;
    }

    public void setGetter(IMethod getter) {
        this.getter = getter;
    }

    public void setIsGetter(IMethod isGetter) {
        this.isGetter = isGetter;
    }

    public void addSetter(IMethod setter) {
        if (setter != null && setter.getNumberOfParameters() == 1) {
            this.setters.add(setter);
        }
    }

    public JDTBeanProperty toValueObject() {
        IMethod choosenSetter;
        IMethod choosenGetter = this.isGetter != null ? this.isGetter : this.getter;
        String unresolvedTypeSig = JDTBeanPropertyWorkingCopy.getUnresolvedType(choosenGetter, choosenSetter = this.chooseSetter(choosenGetter));
        if (unresolvedTypeSig == null) {
            return new JDTBeanProperty(this.propertyName, null, null, Collections.EMPTY_LIST, choosenGetter, choosenSetter);
        }
        String resolvedTypeSig = this.typeResolver.resolveEraseTypeParams(unresolvedTypeSig);
        IType resolvedType = this.resolveType(resolvedTypeSig);
        List<String> parameterizedTypeSignatures = this.getParameterizedTypeSignature(unresolvedTypeSig);
        return new JDTBeanProperty(this.propertyName, resolvedType, resolvedTypeSig, parameterizedTypeSignatures, choosenGetter, choosenSetter);
    }

    private IMethod chooseSetter(IMethod choosenGetter) {
        if (choosenGetter != null) {
            return this.determineMatchedSetter(choosenGetter);
        }
        if (!this.setters.isEmpty()) {
            return this.setters.get(0);
        }
        return null;
    }

    private IMethod determineMatchedSetter(IMethod choosenGetter) {
        if (this.setters.isEmpty()) {
            return null;
        }
        String getterSig = this.typeResolver.resolveEraseTypeParams(JDTBeanPropertyWorkingCopy.getUnresolvedType(choosenGetter, null));
        if (getterSig == null) {
            return null;
        }
        for (IMethod setter : this.setters) {
            assert (setter.getNumberOfParameters() == 1);
            String paramSig = this.typeResolver.resolveEraseTypeParams(setter.getParameterTypes()[0]);
            if (!paramSig.equals(getterSig)) continue;
            return setter;
        }
        return null;
    }

    private static String getUnresolvedType(IMethod choosenGetter, IMethod choosenSetter) {
        try {
            if (choosenGetter != null) {
                return choosenGetter.getReturnType();
            }
            return choosenSetter.getParameterTypes()[0];
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log(jme, "Error resolving bean property type signature");
            return null;
        }
    }

    private IType resolveType(String resolvedTypeSig) {
        String typeSig = Signature.getElementType((String)resolvedTypeSig);
        return TypeUtil.resolveType(this.type, typeSig);
    }

    private List<String> getParameterizedTypeSignature(String unresolvedTypeSignature) {
        ArrayList<String> typeSig = new ArrayList<String>();
        String[] stringArray = Signature.getTypeArguments((String)unresolvedTypeSignature);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String typeArg = stringArray[n2];
            typeSig.add(this.typeResolver.resolveKeepTypeParams(typeArg));
            ++n2;
        }
        return typeSig;
    }
}

