/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class SaveDirtyFilesDialog
extends ListDialog {
    public static final String ALL_MODIFIED_RESOURCES_MUST_BE_SAVED_BEFORE_THIS_OPERATION = Messages.SaveDirtyFilesDialog_message_not_saved;

    public static boolean saveDirtyFiles(String mask) {
        boolean result = true;
        Shell shell = Display.getCurrent().getActiveShell();
        IEditorPart[] dirtyEditors = SaveDirtyFilesDialog.getDirtyEditors(mask);
        if (dirtyEditors.length > 0) {
            result = false;
            SaveDirtyFilesDialog saveDirtyFilesDialog = new SaveDirtyFilesDialog(shell);
            saveDirtyFilesDialog.setInput(Arrays.asList(dirtyEditors));
            if (saveDirtyFilesDialog.open() == 0) {
                result = true;
                int numDirtyEditors = dirtyEditors.length;
                int i = 0;
                while (i < numDirtyEditors) {
                    dirtyEditors[i].doSave(null);
                    ++i;
                }
            } else {
                MessageDialog dlg = new MessageDialog(shell, Messages.SaveDirtyFilesDialog_title_error, null, ALL_MODIFIED_RESOURCES_MUST_BE_SAVED_BEFORE_THIS_OPERATION, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dlg.open();
            }
        }
        return result;
    }

    private static IEditorPart[] getDirtyEditors(String mask) {
        IWorkbenchWindow[] windows;
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart ep = iEditorPartArray[n6];
                    if (ep.getTitle().indexOf(mask) > 0) {
                        result.add(ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public SaveDirtyFilesDialog(Shell parent) {
        super(parent);
        this.setTitle(Messages.SaveDirtyFilesDialog_title);
        this.setAddCancelButton(true);
        this.setLabelProvider(this.createDialogLabelProvider());
        this.setMessage(ALL_MODIFIED_RESOURCES_MUST_BE_SAVED_BEFORE_THIS_OPERATION);
        this.setContentProvider(new ListContentProvider());
    }

    protected Control createDialogArea(Composite container) {
        Composite result = (Composite)super.createDialogArea(container);
        return result;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    static class ListContentProvider
    implements IStructuredContentProvider {
        List fContents;

        ListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        /*
         * WARNING - void declaration
         */
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            void list;
            List list2;
            Object object = newInput;
            this.fContents = object instanceof List && (list2 = (List)object) == (List)object ? list : null;
        }

        public void dispose() {
        }

        public boolean isDeleted(Object o) {
            return this.fContents != null && !this.fContents.contains(o);
        }
    }
}

