/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import org.eclipse.mat.inspections.util.PieFactory;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="pie_biggest_objects")
@Category(value="__hidden__")
public class BiggestObjectsPieQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResultPie execute(IProgressListener listener) throws Exception {
        int[] objects = this.snapshot.getImmediateDominatedIds(-1);
        long totalHeapSize = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        int index = 0;
        int count = 0;
        long retainedHeapBySlices = 0L;
        PieFactory pie = new PieFactory(this.snapshot);
        while (index < objects.length && (count < 3 || retainedHeapBySlices < totalHeapSize / 4L && count < 10)) {
            IObject obj = this.snapshot.getObject(objects[index++]);
            IResultPie.Slice slice = pie.addSlice(obj.getObjectId());
            retainedHeapBySlices = (long)((double)retainedHeapBySlices + slice.getValue());
            ++count;
            if (slice.getValue() < (double)(totalHeapSize / 100L) || listener.isCanceled()) break;
        }
        return pie.build();
    }
}

