/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Customized Retained Set")
@Category(value="Java Basics")
@Icon(value="/META-INF/icons/show_retained_set.gif")
@Help(value="Calculate the retained set of objects excluding references via given fields.\n\nThe custom retained set comprises all objects included in the normal retained set. Additionally, it adds objects which are (a) reachable from the root set and (b) would be garbage collected if the references defined by the excludes would not exist.\n\nIn terms of set operations, one could put it this way: the customized retained set contains all objects which are unreachable if all references to the root set and all references defined by the excludes are removed. From the resulting set, the objects of the retained set derived only through the excludes are removed.\n\nFor example, to calculate the retained set of all classes in a package including those objects that would be freed only after the finalizer run (only on Sun's VM!), one could say:\n\tcustom_retained_set sample\\.package.* -x java.lang.ref.Finalizer:referent\n\nThe excludes are specified as follows:\n\texclude ::= ( <objectAddress> | <className> ) [: <field> [, <field> ]]\nExample:\n\tjava.lang.ref.WeakReference:referent\n\t0x4711:attrib1,attrib2\n\nUse the argument 'xfile' to read excludes from the file. Each lines must have the same format.")
public class CustomizedRetainedSetQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="Root set of objects for the retained set calculation")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, flag="x")
    @Help(value="Exclude definitions")
    public String[] excludedReferences;
    @Argument(isMandatory=false, flag="xfile")
    @Help(value="File containing exclude definitions")
    public File excludedReferencesListFile;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] retainedSet;
        if (this.excludedReferences == null && this.excludedReferencesListFile == null) {
            retainedSet = this.snapshot.getRetainedSet(this.objects.getIds(listener), listener);
        } else {
            String[] fromFile = this.getLinesFromFile();
            if (fromFile != null && fromFile.length > 0) {
                if (this.excludedReferences != null) {
                    String[] tmp = new String[fromFile.length + this.excludedReferences.length];
                    System.arraycopy(fromFile, 0, tmp, 0, fromFile.length);
                    System.arraycopy(this.excludedReferences, 0, tmp, fromFile.length, this.excludedReferences.length);
                    this.excludedReferences = tmp;
                } else {
                    this.excludedReferences = fromFile;
                }
            }
            ExcludedReferencesDescriptor[] excludedRefDescriptors = this.getExcludedReferenceDescriptors(this.excludedReferences);
            retainedSet = this.snapshot.getRetainedSet(this.objects.getIds(listener), excludedRefDescriptors, listener);
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Histogram histogram = this.snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(MessageFormat.format("Retained by ''{0}''", this.objects.getLabel()));
        return histogram;
    }

    private ExcludedReferencesDescriptor[] getExcludedReferenceDescriptors(String[] excludedRefs) throws SnapshotException {
        ExcludedReferencesDescriptor[] result = new ExcludedReferencesDescriptor[excludedRefs.length];
        int i = 0;
        String[] stringArray = excludedRefs;
        int n = excludedRefs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            StringTokenizer tokenizer = new StringTokenizer(s, ":");
            String objectsDescription = tokenizer.nextToken();
            ArrayIntBig objectIds = new ArrayIntBig();
            if (objectsDescription.startsWith("0x")) {
                long objAddress = Long.parseLong(objectsDescription.substring(2), 16);
                objectIds.add(this.snapshot.mapAddressToId(objAddress));
            } else {
                Collection<IClass> classes = this.snapshot.getClassesByName(objectsDescription, true);
                for (IClass clazz : classes) {
                    objectIds.addAll(clazz.getObjectIds());
                }
            }
            HashSet<String> fields = null;
            if (tokenizer.hasMoreTokens()) {
                fields = new HashSet<String>();
                StringTokenizer fieldTokenizer = new StringTokenizer(tokenizer.nextToken(), ",");
                while (fieldTokenizer.hasMoreTokens()) {
                    fields.add(fieldTokenizer.nextToken());
                }
            }
            ExcludedReferencesDescriptor desc = new ExcludedReferencesDescriptor(objectIds.toArray(), fields);
            result[i++] = desc;
            ++n2;
        }
        return result;
    }

    private String[] getLinesFromFile() throws Exception {
        if (this.excludedReferencesListFile == null) {
            return null;
        }
        BufferedReader in = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(this.excludedReferencesListFile));
            String line = null;
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result.toArray(new String[0]);
    }
}

