/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.ObjectComparators;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="Duplicate Classes")
@Category(value="Java Basics")
@Help(value="Extract classes loaded multiple times.")
public class DuplicatedClassesQuery
implements IQuery,
IResultTree,
IIconProvider,
ITestResult,
IDecorator,
ISelectionProvider {
    @Argument
    public ISnapshot snapshot;
    private List<List<IClass>> problems;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        IClass[] allClasses = this.snapshot.getClasses().toArray(new IClass[0]);
        int length = allClasses.length;
        listener.beginTask("Checking for duplicate Classes", length / 100);
        Arrays.sort(allClasses, ObjectComparators.getComparatorForTechnicalNameAscending());
        this.problems = new ArrayList<List<IClass>>();
        String previousName = allClasses[0].getName();
        int ii = 1;
        while (ii < length) {
            if (previousName.equals(allClasses[ii].getName())) {
                ArrayList<IClass> duplicates = new ArrayList<IClass>();
                this.problems.add(duplicates);
                --ii;
                while (ii < length && allClasses[ii].getName().equals(previousName)) {
                    duplicates.add(allClasses[ii]);
                    ++ii;
                }
            }
            if (ii < length) {
                previousName = allClasses[ii].getName();
            }
            if (ii % 100 == 0) {
                listener.worked(1);
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ++ii;
        }
        return this;
    }

    public ITestResult.Status getStatus() {
        return this.problems.isEmpty() ? ITestResult.Status.SUCCESS : ITestResult.Status.WARNING;
    }

    public ResultMetaData getResultMetaData() {
        return null;
    }

    public Column[] getColumns() {
        return new Column[]{new Column("Name").decorator((IDecorator)this), new Column("Count", Integer.TYPE).sorting(Column.SortDirection.DESC), new Column("Defined Classes", Integer.TYPE).noTotals(), new Column("No. of Instances", Integer.TYPE).noTotals()};
    }

    public List<?> getElements() {
        return this.problems;
    }

    public boolean hasChildren(Object parent) {
        return parent instanceof List;
    }

    public List<?> getChildren(Object parent) {
        if (parent instanceof List) {
            return (List)parent;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getColumnValue(Object element, int columnIndex) {
        if (element instanceof List) {
            switch (columnIndex) {
                case 0: {
                    return ((IClass)((List)element).get(0)).getName();
                }
                case 1: {
                    return ((List)element).size();
                }
            }
            return null;
        }
        if (!(element instanceof IClass)) return null;
        if (columnIndex == 1) return null;
        try {
            IClassLoader classLoader = (IClassLoader)this.snapshot.getObject(((IClass)element).getClassLoaderId());
            switch (columnIndex) {
                case 0: {
                    String loaderName = classLoader.getClassSpecificName();
                    if (loaderName == null) return classLoader.getTechnicalName();
                    return String.valueOf(loaderName) + " @ 0x" + Long.toHexString(classLoader.getObjectAddress());
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return classLoader.getDefinedClasses().size();
                }
                case 3: {
                    int instantiatedObjects = 0;
                    Iterator<IClass> iterator = classLoader.getDefinedClasses().iterator();
                    while (iterator.hasNext()) {
                        IClass clazz = iterator.next();
                        instantiatedObjects += clazz.getNumberOfObjects();
                    }
                    return instantiatedObjects;
                }
            }
            return null;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(MessageFormat.format("ClassLoader of 0x{0} not found", Long.toHexString(((IClass)element).getObjectAddress())), e);
        }
    }

    public String prefix(Object row) {
        return null;
    }

    public String suffix(Object row) {
        if (!(row instanceof IClass)) {
            return null;
        }
        try {
            GCRootInfo[] roots = ((IClass)row).getGCRootInfo();
            return roots != null ? GCRootInfo.getTypeSetAsString(roots) : null;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getIcon(Object element) {
        if (element instanceof List) {
            return Icons.CLASS;
        }
        if (element instanceof IClass) {
            return Icons.forObject(this.snapshot, ((IClass)element).getClassLoaderId());
        }
        return null;
    }

    public IContextObject getContext(final Object element) {
        if (element instanceof List) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return -1;
                }

                public int[] getObjectIds() {
                    List classes = (List)element;
                    int[] answer = new int[classes.size()];
                    int ii = 0;
                    for (IClass c : classes) {
                        answer[ii++] = c.getObjectId();
                    }
                    return answer;
                }

                public String getOQL() {
                    return OQL.forObjectIds(this.getObjectIds());
                }
            };
        }
        if (element instanceof IClass) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((IClass)element).getClassLoaderId();
                }
            };
        }
        return null;
    }

    public boolean isExpanded(Object row) {
        return this.problems.isEmpty() ? false : row == this.problems.get(0);
    }

    public boolean isSelected(Object row) {
        return false;
    }
}

