/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Find Strings")
@Category(value="Java Basics")
@Help(value="Find Strings matching the regular expression.")
public class FindStringsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    @Help(value="Optionally limit the search to Strings in this object set.")
    public IHeapObjectArgument objects;
    @Argument
    public Pattern pattern;

    public IResult execute(IProgressListener listener) throws Exception {
        ArrayInt result;
        block11: {
            InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
            listener.subTask("Searching Strings...");
            result = new ArrayInt();
            if (this.objects == null) {
                for (IClass clasz : this.snapshot.getClassesByName("java.lang.String", false)) {
                    int[] objectIds;
                    int[] nArray = objectIds = clasz.getObjectIds();
                    int n = objectIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        if (!listener.isCanceled()) {
                            String value = this.snapshot.getObject(id).getClassSpecificName();
                            if (value != null && this.pattern.matcher(value).matches()) {
                                result.add(id);
                            }
                            ++n2;
                            continue;
                        }
                        break block11;
                    }
                }
            } else {
                IClass javaLangString = this.snapshot.getClassesByName("java.lang.String", false).iterator().next();
                Iterator iterator = this.objects.iterator();
                while (iterator.hasNext()) {
                    int[] objectIds;
                    int[] nArray = objectIds = (int[])iterator.next();
                    int n = objectIds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        if (!listener.isCanceled()) {
                            String value;
                            IObject instance;
                            if (!this.snapshot.isArray(id) && !this.snapshot.isClass(id) && !this.snapshot.isClassLoader(id) && javaLangString.equals((instance = this.snapshot.getObject(id)).getClazz()) && this.pattern.matcher(value = instance.getClassSpecificName()).matches()) {
                                result.add(id);
                            }
                            ++n3;
                            continue;
                        }
                        break block11;
                    }
                }
            }
        }
        if (listener.isCanceled() && result.isEmpty()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

