/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Group By Value")
@Category(value="Java Basics")
@Help(value="Group objects by their string representation.\n\nBy default, the objects are grouped by the the class specific name resolver. Alternatively, one can specify a field using the dot notation, whose name resolver is then used.\n\nExamples:\nTo find duplicate strings, run:\n\tgroup_by_value java.lang.String\nTo group array lists by their size, run:\n\tgroup_by_value java.util.ArrayList -field size\n")
public class GroupByValueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="An optional dot notation to specify a field which is used to group the objects, e.g. modCount to group HashMaps by their modifications.")
    public String field;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        listener.subTask("Grouping objects ...");
        Quantize quantize = Quantize.valueDistribution((String[])new String[]{"String Value"}).column("Objects", Quantize.COUNT).column("Shallow Heap", Quantize.SUM_LONG, Column.SortDirection.DESC).addDerivedData(RetainedSizeDerivedData.APPROXIMATE).build();
        for (int[] objectIds : this.objects) {
            int ii = 0;
            while (ii < objectIds.length) {
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                int objectId = objectIds[ii];
                IObject object = this.snapshot.getObject(objectId);
                Object subject = object;
                if (this.field != null) {
                    subject = object.resolveValue(this.field);
                }
                if (subject instanceof IObject) {
                    subject = subject.getClassSpecificName();
                }
                quantize.addValue(objectId, new Object[]{subject, null, object.getUsedHeapSize()});
                ++ii;
            }
        }
        return quantize.getResult();
    }
}

