/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Show As Histogram")
@CommandName(value="histogram")
@Category(value="Java Basics")
@Icon(value="/META-INF/icons/show_histogram.gif")
@Help(value="Create a histogram from an arbitrary set of objects.\n\nIf you need the retained set as an histogram, use the retained_set query.")
public class HistogramQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", isMandatory=false)
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="Deprecated. Use groupBy instead.")
    @Deprecated
    public boolean byClassLoader = false;
    @Argument(isMandatory=false)
    public Grouping groupBy = Grouping.BY_CLASS;

    public IResult execute(IProgressListener listener) throws Exception {
        Histogram histogram;
        Histogram histogram2 = histogram = this.objects == null ? this.snapshot.getHistogram(listener) : this.snapshot.getHistogram(this.objects.getIds(listener), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        if (this.objects != null) {
            histogram.setLabel(MessageFormat.format("Histogram of {0}", this.objects.getLabel()));
        }
        if (this.byClassLoader) {
            this.groupBy = Grouping.BY_CLASSLOADER;
        }
        switch (this.groupBy) {
            case BY_CLASS: {
                return histogram;
            }
            case BY_CLASSLOADER: {
                return histogram.groupByClassLoader();
            }
            case BY_PACKAGE: {
                return histogram.groupByPackage();
            }
        }
        throw new RuntimeException(MessageFormat.format("Illegal groupBy argument: {0}", new Object[]{this.groupBy}));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grouping {
        BY_CLASS("Group by class", Icons.CLASS),
        BY_CLASSLOADER("Group by class loader", Icons.CLASSLOADER_INSTANCE),
        BY_PACKAGE("Group by package", Icons.PACKAGE);

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }
}

