/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.DominatorsSummary;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Immediate Dominators")
@Icon(value="/META-INF/icons/immediate_dominators.gif")
@Help(value="Find and aggregate on class level all objects dominating a given set of objects.\n\nThe immediate dominators of all char arrays (immediate_dominators char[]) are all objects responsible for keeping the char[] alive. The result will contain most likely java.lang.String objects. Now add the skip pattern java.*, and you will see the non-JDK classes responsible for the char arrays.")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/immediate_dominators.html#ref_inspections_immediate_dominators__result")
public class ImmediateDominatorsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    @Help(value="A regular expression specifying which dominators to skip while going up the dominator tree. If the dominator of an object matches the pattern, then the dominator of the dominator will be taken, and so on, until an object not matching the skip pattern is reached.")
    public Pattern skipPattern = Pattern.compile("java.*|com\\.sun\\..*");

    public IResult execute(IProgressListener listener) throws Exception {
        DominatorsSummary summary = this.snapshot.getDominatorsOf(this.objects.getIds(listener), this.skipPattern, listener);
        return new ResultImpl(summary);
    }

    public static class ResultImpl
    implements IResultTable,
    IIconProvider {
        DominatorsSummary summary;

        public ResultImpl(DominatorsSummary summary) {
            this.summary = summary;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider("Objects"){

                public IContextObject getContext(Object row) {
                    return ResultImpl.this.getObjects(row);
                }
            }).addContext(new ContextProvider("Dominated Objects"){

                public IContextObject getContext(Object row) {
                    return ResultImpl.this.getDominatedObjects(row);
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column("Class name"), new Column("Objects", Long.class), new Column("Dom. Objects", Long.class), new Column("Shallow Heap", Long.class), new Column("Dom. Shallow Heap", Long.class).sorting(Column.SortDirection.DESC)};
        }

        public int getRowCount() {
            return this.summary.getClassDominatorRecords().length;
        }

        public DominatorsSummary.ClassDominatorRecord getRow(int rowId) {
            return this.summary.getClassDominatorRecords()[rowId];
        }

        public URL getIcon(Object row) {
            return Icons.CLASS;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            switch (columnIndex) {
                case 0: {
                    return record.getClassName();
                }
                case 1: {
                    return record.getDominatorCount();
                }
                case 2: {
                    return record.getDominatedCount();
                }
                case 3: {
                    return record.getDominatorNetSize();
                }
                case 4: {
                    return record.getDominatedNetSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            if (record.getClassId() >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return record.getClassId();
                    }
                };
            }
            return null;
        }

        IContextObject getObjects(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            if (record.getClassId() >= 0) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getDominators();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return null;
        }

        IContextObject getDominatedObjects(Object row) {
            final DominatorsSummary.ClassDominatorRecord record = (DominatorsSummary.ClassDominatorRecord)row;
            return new IContextObjectSet(){

                public int getObjectId() {
                    return record.getClassId();
                }

                public int[] getObjectIds() {
                    return record.getDominated();
                }

                public String getOQL() {
                    return null;
                }
            };
        }
    }
}

