/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.inspections.FindLeaksQuery;
import org.eclipse.mat.inspections.threads.ThreadInfoQuery;
import org.eclipse.mat.inspections.util.ObjectTreeFactory;
import org.eclipse.mat.inspections.util.PieFactory;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.ITroubleTicketResolver;
import org.eclipse.mat.snapshot.inspections.MultiplePath2GCRootsQuery;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.snapshot.registry.TroubleTicketResolverRegistry;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="Find Leaks")
@CommandName(value="leakhunter")
@Category(value="Leak Identification")
@Help(value="Report potential memory leaks.\n\nThe query analyzes the dominator tree and searches for big memory chunks (by default more than 10% of the total heap). These could be single objects or groups of objects from the same class. Then it tries to automatically find the exact accumulation point - usually an array or a collection.")
public class LeakHunterQuery
implements IQuery {
    private static final Set<String> REFERENCE_FIELD_SET = new HashSet<String>((Collection)Arrays.asList("referent"));
    static final String SYSTEM_CLASSLOADER = "&lt;system class loader&gt;";
    static NumberFormat percentFormatter = new DecimalFormat("0.00%");
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public int threshold_percent = 10;
    @Argument(isMandatory=false)
    public int max_paths = 10000;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    @Help(value="A regular expression specifying which dominators/referers to skip when a problematic object is described.")
    public Pattern skipPattern = Pattern.compile("java.*|com\\.sun\\..*");
    private long totalHeap;
    private final IProgressListener voidListener = new VoidProgressListener();
    private IProgressListener listener;

    public IResult execute(IProgressListener listener) throws Exception {
        this.listener = listener;
        this.totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        listener.subTask("Finding problem suspects");
        FindLeaksQuery.SuspectsResultTable findLeaksResult = this.callFindLeaks(this.voidListener);
        FindLeaksQuery.SuspectRecord[] leakSuspects = findLeaksResult.getData();
        SectionSpec result = new SectionSpec("Leak Hunter");
        listener.subTask("Preparing results");
        if (leakSuspects.length > 0) {
            PieFactory pie = new PieFactory(this.snapshot);
            int num = 0;
            while (num < leakSuspects.length) {
                FindLeaksQuery.SuspectRecord rec = leakSuspects[num];
                pie.addSlice(-1, "Problem Suspect " + (num + 1), 0L, rec.suspectRetained);
                ++num;
            }
            result.add((Spec)new QuerySpec("Overview", (IResult)pie.build()));
            HashMap<Integer, List<Integer>> accPoint2ProblemNr = new HashMap<Integer, List<Integer>>();
            int problemNum = 0;
            FindLeaksQuery.SuspectRecord[] suspectRecordArray = leakSuspects;
            int n = leakSuspects.length;
            int n2 = 0;
            while (n2 < n) {
                FindLeaksQuery.SuspectRecord rec = suspectRecordArray[n2];
                ++problemNum;
                FindLeaksQuery.AccumulationPoint ap = rec.getAccumulationPoint();
                if (ap != null) {
                    List<Integer> numbers = accPoint2ProblemNr.get(ap);
                    if (numbers == null) {
                        numbers = new ArrayList<Integer>(2);
                        accPoint2ProblemNr.put(ap.getObject().getObjectId(), numbers);
                    }
                    numbers.add(problemNum);
                }
                CompositeResult suspectDetails = this.getLeakSuspectDescription(rec, listener);
                suspectDetails.setStatus(ITestResult.Status.ERROR);
                QuerySpec spec = new QuerySpec("Problem Suspect " + problemNum);
                spec.setResult((IResult)suspectDetails);
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", "true");
                result.add((Spec)spec);
                ++n2;
            }
            List<CompositeResult> hints = this.findCommonPathForSuspects(accPoint2ProblemNr);
            int k = 0;
            while (k < hints.size()) {
                QuerySpec spec = new QuerySpec("Hint " + (k + 1));
                spec.setResult((IResult)hints.get(k));
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", "true");
                result.add((Spec)spec);
                ++k;
            }
        }
        if (result.getChildren().size() != 0) {
            return result;
        }
        return new TextResult("No leak suspect was found");
    }

    private FindLeaksQuery.SuspectsResultTable callFindLeaks(IProgressListener listener) throws Exception {
        return (FindLeaksQuery.SuspectsResultTable)SnapshotQuery.lookup("find_leaks", this.snapshot).set("threshold_percent", this.threshold_percent).set("max_paths", this.max_paths).execute(listener);
    }

    private boolean isThreadRelated(FindLeaksQuery.SuspectRecord suspect) throws SnapshotException {
        return this.isThread(suspect.getSuspect().getObjectId());
    }

    private boolean isThread(int objectId) throws SnapshotException {
        GCRootInfo[] gcRootInfo = this.snapshot.getGCRootInfo(objectId);
        if (gcRootInfo != null) {
            GCRootInfo[] gCRootInfoArray = gcRootInfo;
            int n = gcRootInfo.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo singleInfo = gCRootInfoArray[n2];
                if (singleInfo.getType() == 256) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private CompositeResult getLeakSuspectDescription(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        if (suspect instanceof FindLeaksQuery.SuspectRecordGroupOfObjects) {
            return this.getLeakDescriptionGroupOfObjects((FindLeaksQuery.SuspectRecordGroupOfObjects)suspect);
        }
        return this.getLeakDescriptionSingleObject(suspect, listener);
    }

    private CompositeResult getLeakDescriptionSingleObject(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        String classloaderName;
        IClassLoader suspectClassloader;
        String className;
        StringBuilder overview = new StringBuilder(256);
        HashSet<String> keywords = new HashSet<String>();
        ArrayList<IClassLoader> involvedClassloaders = new ArrayList<IClassLoader>(2);
        int suspectId = suspect.getSuspect().getObjectId();
        boolean isThreadRelated = this.isThreadRelated(suspect);
        if (isThreadRelated) {
            overview.append("<p>");
            overview.append("The thread <b>").append(suspect.getSuspect().getDisplayName()).append("</b> keeps local variables with total size ").append("<b>").append(this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)).append("</b> bytes.");
            overview.append("</p>");
        } else if (this.snapshot.isClassLoader(suspectId)) {
            IClassLoader suspectClassloader2 = (IClassLoader)suspect.getSuspect();
            involvedClassloaders.add(suspectClassloader2);
            String classloaderName2 = this.getClassloarerName(suspectClassloader2, keywords);
            overview.append("The classloader/component <b>&quot;" + classloaderName2 + "&quot;</b> occupies <b>" + this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap) + "</b> bytes. ");
        } else if (this.snapshot.isClass(suspectId)) {
            className = ((IClass)suspect.getSuspect()).getName();
            keywords.add(className);
            suspectClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
            involvedClassloaders.add(suspectClassloader);
            classloaderName = this.getClassloarerName(suspectClassloader, keywords);
            overview.append("The class <b>&quot;" + className + "&quot;</b>, loaded by <b>&quot;" + classloaderName + "&quot;</b>, occupies <b>" + this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap) + "</b> bytes. ");
        } else {
            int referrerId;
            className = suspect.getSuspect().getClazz().getName();
            keywords.add(className);
            suspectClassloader = (IClassLoader)this.snapshot.getObject(suspect.getSuspect().getClazz().getClassLoaderId());
            involvedClassloaders.add(suspectClassloader);
            classloaderName = this.getClassloarerName(suspectClassloader, keywords);
            overview.append("One instance of <b>&quot;" + className + "&quot;</b> loaded by <b>&quot;" + classloaderName + "&quot;</b> occupies <b>" + this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap) + "</b> bytes. ");
            if (this.skipPattern.matcher(className).matches() && !isThreadRelated && (referrerId = this.findReferrer(suspect.getSuspect().getObjectId())) != -1) {
                IObject referrer = this.snapshot.getObject(referrerId);
                overview.append("The instance is referenced by ");
                IObject referrerClassloader = null;
                if (this.snapshot.isClassLoader(referrerId)) {
                    referrerClassloader = referrer;
                    involvedClassloaders.add(suspectClassloader);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append("classloader/component. <b>&quot;").append(referrerClassloaderName).append("&quot;</b>. ");
                } else if (this.snapshot.isClass(referrerId)) {
                    referrerClassloader = this.snapshot.getObject(((IClass)referrer).getClassLoaderId());
                    involvedClassloaders.add(suspectClassloader);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append("class <b>&quot;" + className + "&quot;</b>, loaded by <b>&quot;" + referrerClassloaderName + "&quot;</b>. ");
                } else {
                    if (this.isThread(referrerId)) {
                        isThreadRelated = true;
                        suspectId = referrerId;
                    }
                    referrerClassloader = this.snapshot.getObject(referrer.getClazz().getClassLoaderId());
                    involvedClassloaders.add(suspectClassloader);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append("<b>").append(referrer.getDisplayName()).append("</b>&nbsp;").append(", loaded by <b>&quot;" + referrerClassloaderName + "&quot;</b>. ");
                }
            }
        }
        if (suspect.getAccumulationPoint() != null) {
            String classloaderName3;
            IObject accumulationObject = suspect.getAccumulationPoint().getObject();
            int accumulationPointId = accumulationObject.getObjectId();
            if (this.snapshot.isClassLoader(accumulationPointId)) {
                IClassLoader accPointClassloader = (IClassLoader)accumulationObject;
                involvedClassloaders.add(accPointClassloader);
                String classloaderName4 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append("The memory is accumulated in classloader/component <b>&quot;" + classloaderName4 + "&quot;</b>.");
            } else if (this.snapshot.isClass(accumulationPointId)) {
                IClass clazz = (IClass)accumulationObject;
                keywords.add(clazz.getName());
                IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(clazz.getClassLoaderId());
                involvedClassloaders.add(accPointClassloader);
                classloaderName3 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append("The memory is accumulated in class <b>&quot;" + clazz.getName() + "&quot;</b>, loaded by <b>&quot;" + classloaderName3 + "&quot;</b>.");
            } else {
                String className2 = accumulationObject.getClazz().getName();
                keywords.add(className2);
                IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(accumulationObject.getClazz().getClassLoaderId());
                involvedClassloaders.add(accPointClassloader);
                classloaderName3 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append("The memory is accumulated in one instance of <b>&quot;" + className2 + "&quot;</b> loaded by <b>&quot;" + classloaderName3 + "&quot;</b>.");
            }
        }
        overview.append("</p>");
        ThreadInfoQuery.Result threadDetails = null;
        if (isThreadRelated) {
            threadDetails = this.extractThreadData(suspectId, keywords, involvedClassloaders, overview);
        }
        this.appendKeywords(keywords, overview);
        this.appendTroubleTicketInformation(involvedClassloaders, overview);
        CompositeResult composite = new CompositeResult(new IResult[0]);
        composite.addResult("Description", (IResult)new TextResult(overview.toString(), true));
        IObject describedObject = suspect.getAccumulationPoint() != null ? suspect.getAccumulationPoint().getObject() : suspect.getSuspect();
        try {
            IResult result = SnapshotQuery.lookup("path2gc", this.snapshot).set("object", describedObject).execute(listener);
            composite.addResult("Shortest Paths To the Accumulation Point", result);
        }
        catch (Exception e) {
            throw new SnapshotException("Error creating shortest paths to accumulation point.", (Throwable)e);
        }
        IResult objectInDominatorTree = this.showInDominatorTree(describedObject.getObjectId());
        composite.addResult("Accumulated Objects", objectInDominatorTree);
        IResult histogramOfDominated = this.getHistogramOfDominated(describedObject.getObjectId());
        if (histogramOfDominated != null) {
            composite.addResult("Accumulated Objects by Class", histogramOfDominated);
        }
        if (threadDetails != null) {
            composite.addResult("Thread Details", (IResult)threadDetails);
        }
        return composite;
    }

    /*
     * WARNING - void declaration
     */
    private CompositeResult getLeakDescriptionGroupOfObjects(FindLeaksQuery.SuspectRecordGroupOfObjects suspect) throws SnapshotException {
        void var11_12;
        StringBuilder builder = new StringBuilder(256);
        HashSet<String> keywords = new HashSet<String>();
        ArrayList<IClassLoader> involvedClassLoaders = new ArrayList<IClassLoader>(2);
        String className = ((IClass)suspect.getSuspect()).getName();
        keywords.add(className);
        IClassLoader classloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
        involvedClassLoaders.add(classloader);
        String classloaderName = this.getClassloarerName(classloader, keywords);
        String numberOfInstances = numberFormatter.format(suspect.getSuspectInstances().length);
        builder.append(String.valueOf(numberOfInstances) + " instances of <b>&quot;" + className + "&quot;</b>, loaded by <b>&quot;" + classloaderName + "&quot;</b> occupy <b>" + this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap) + "</b> bytes. ");
        int[] suspectInstances = suspect.getSuspectInstances();
        ArrayList<Object> bigSuspectInstances = new ArrayList<Object>();
        boolean bl = false;
        while (var11_12 < suspectInstances.length) {
            IObject inst = this.snapshot.getObject(suspectInstances[var11_12]);
            if (inst.getRetainedHeapSize() < this.totalHeap / 100L) break;
            bigSuspectInstances.add(inst);
            ++var11_12;
        }
        if (bigSuspectInstances.size() > 0) {
            builder.append("<p>Biggest instances:");
            for (IObject iObject : bigSuspectInstances) {
                builder.append("<li>").append(iObject.getDisplayName());
                builder.append("&nbsp;-&nbsp").append(String.valueOf(this.formatRetainedHeap(iObject.getRetainedHeapSize(), this.totalHeap)) + " bytes. ");
            }
            builder.append("</p>");
        }
        if (suspect.getAccumulationPoint() != null) {
            IClassLoader accPointClassloader;
            int n = suspect.getAccumulationPoint().getObject().getObjectId();
            if (this.snapshot.isClassLoader(n)) {
                involvedClassLoaders.add((IClassLoader)suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassloarerName(suspect.getAccumulationPoint().getObject(), keywords);
                builder.append("These instances are referenced from classloader/component <b>&quot;" + classloaderName + "&quot;</b>");
            } else if (this.snapshot.isClass(n)) {
                className = ((IClass)suspect.getAccumulationPoint().getObject()).getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getAccumulationPoint().getObject()).getClassLoaderId());
                involvedClassLoaders.add(accPointClassloader);
                classloaderName = this.getClassloarerName(accPointClassloader, keywords);
                builder.append("These instances are referenced from the class <b>&quot;" + className + "&quot;</b>, loaded by <b>&quot;" + classloaderName + "&quot;</b>");
            } else {
                className = suspect.getAccumulationPoint().getObject().getClazz().getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(suspect.getAccumulationPoint().getObject().getClazz().getClassLoaderId());
                involvedClassLoaders.add(accPointClassloader);
                classloaderName = this.getClassloarerName(accPointClassloader, keywords);
                builder.append("These instances are referenced from one instance of <b>&quot;" + className + "&quot;</b>, loaded by <b>&quot;" + classloaderName + "&quot;</b>");
            }
        }
        builder.append("<br><br>");
        this.appendKeywords(keywords, builder);
        this.appendTroubleTicketInformation(involvedClassLoaders, builder);
        CompositeResult compositeResult = new CompositeResult(new IResult[0]);
        compositeResult.addResult("Description", (IResult)new TextResult(builder.toString(), true));
        FindLeaksQuery.AccumulationPoint accPoint = suspect.getAccumulationPoint();
        if (accPoint != null) {
            compositeResult.addResult("Common Path To the Accumulation Point", (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, suspect.getPathsComputer(), suspect.getCommonPath()));
        } else {
            IResult result = this.findReferencePattern(suspect);
            if (result != null) {
                compositeResult.addResult("Reference Pattern", result);
            }
        }
        return compositeResult;
    }

    private String formatRetainedHeap(long retained, long totalHeap) {
        return String.valueOf(numberFormatter.format(retained)) + " (" + percentFormatter.format((double)retained / (double)totalHeap) + ")";
    }

    private Map<String, String> getTroubleTicketMapping(ITroubleTicketResolver resolver, List<IClassLoader> classloaders) throws SnapshotException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (IClassLoader classloader : classloaders) {
            String old;
            String ticket = resolver.resolve(classloader, (IProgressListener)new VoidProgressListener());
            if (ticket == null || "".equals(ticket.trim())) continue;
            String classloaderName = classloader.getClassSpecificName();
            if (classloaderName == null) {
                classloaderName = classloader.getTechnicalName();
            }
            if ((old = mapping.put(ticket, classloaderName)) == null) continue;
            mapping.put(ticket, String.valueOf(classloaderName) + ", " + old);
        }
        return mapping;
    }

    private String getName(IObject object) {
        String name = object.getClassSpecificName();
        if (name == null) {
            name = object.getTechnicalName();
        }
        return name;
    }

    private String getClassloarerName(IObject classloader, Set<String> keywords) {
        if (classloader.getObjectAddress() == 0L) {
            return SYSTEM_CLASSLOADER;
        }
        String classloaderName = this.getName(classloader);
        if (keywords != null) {
            keywords.add(classloaderName);
        }
        return classloaderName;
    }

    private IResult showInDominatorTree(int objectId) throws SnapshotException {
        Stack<Integer> tmp = new Stack<Integer>();
        int e = objectId;
        while (e != -1) {
            tmp.push(e);
            e = this.snapshot.getImmediateDominatorId(e);
        }
        ObjectTreeFactory.TreePathBuilder treeBuilder = new ObjectTreeFactory.TreePathBuilder(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        treeBuilder.setIsOutgoing();
        treeBuilder.addBranch((Integer)tmp.pop());
        while (tmp.size() > 0) {
            treeBuilder.addChild(e, (e = ((Integer)tmp.pop()).intValue()) == objectId);
        }
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        int i = 0;
        while (i < 20 && i < dominatedByAccPoint.length) {
            treeBuilder.addSibling(dominatedByAccPoint[i], false);
            ++i;
        }
        return treeBuilder.build(this.snapshot);
    }

    private IResult getHistogramOfDominated(int objectId) throws SnapshotException {
        ClassHistogramRecord[] records;
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        Histogram h = this.snapshot.getHistogram(dominatedByAccPoint, this.voidListener);
        ClassHistogramRecord[] classHistogramRecordArray = records = h.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            ClassHistogramRecord record = classHistogramRecordArray[n2];
            record.setRetainedHeapSize(this.snapshot.getMinRetainedSize(record.getObjectIds(), this.voidListener));
            ++n2;
        }
        Arrays.sort(records, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        ArrayList<ClassHistogramRecord> suspects = new ArrayList<ClassHistogramRecord>();
        int limit = 0;
        ClassHistogramRecord[] classHistogramRecordArray2 = records;
        int n3 = records.length;
        int n4 = 0;
        while (n4 < n3) {
            ClassHistogramRecord record = classHistogramRecordArray2[n4];
            if (limit >= 20) break;
            suspects.add(record);
            ++limit;
            ++n4;
        }
        ListResult result = new ListResult(ClassHistogramRecord.class, suspects, new String[]{"label", "numberOfObjects", "usedHeapSize", "retainedHeapSize"}){

            public URL getIcon(Object row) {
                return Icons.forObject(LeakHunterQuery.this.snapshot, ((ClassHistogramRecord)row).getClassId());
            }

            public IContextObject getContext(final Object row) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((ClassHistogramRecord)row).getClassId();
                    }
                };
            }
        };
        return result;
    }

    private void appendKeywords(Set<String> keywords, StringBuilder builder) {
        builder.append("<b>Keywords</b><br>");
        for (String s : keywords) {
            builder.append(s).append("<br>");
        }
    }

    private void appendTroubleTicketInformation(List<IClassLoader> classloaders, StringBuilder builder) throws SnapshotException {
        for (ITroubleTicketResolver resolver : TroubleTicketResolverRegistry.instance().delegates()) {
            Map<String, String> mapping = this.getTroubleTicketMapping(resolver, classloaders);
            if (mapping.isEmpty()) continue;
            builder.append("<p><b>").append(resolver.getTicketSystem()).append("</b><br>");
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                builder.append(entry.getKey()).append(" for \"").append(entry.getValue()).append("\"<br>");
            }
            builder.append("</p>");
        }
    }

    private ThreadInfoQuery.Result extractThreadData(int threadId, Set<String> keywords, List<IClassLoader> involvedClassloaders, StringBuilder builder) {
        ThreadInfoQuery.Result threadDetails = null;
        try {
            int contextClassloaderId;
            threadDetails = (ThreadInfoQuery.Result)SnapshotQuery.lookup("thread_details", this.snapshot).set("threadIds", threadId).execute(this.listener);
            IThreadInfo threadInfo = threadDetails.getThreads().get(0);
            keywords.addAll(threadInfo.getKeywords());
            CompositeResult requestInfos = threadInfo.getRequests();
            if (requestInfos != null && !requestInfos.isEmpty()) {
                builder.append("<p>");
                for (CompositeResult.Entry requestInfo : requestInfos.getResultEntries()) {
                    builder.append(requestInfo.getName()).append("<br>");
                }
                builder.append("</p>");
            }
            if ((contextClassloaderId = threadInfo.getContextClassLoaderId()) != 0) {
                involvedClassloaders.add((IClassLoader)this.snapshot.getObject(contextClassloaderId));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error retrieving request details", e);
        }
        return threadDetails;
    }

    private IResult findReferencePattern(FindLeaksQuery.SuspectRecordGroupOfObjects suspect) throws SnapshotException {
        Object[] allPaths;
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, true, this.snapshot);
        Object[] objectArray = allPaths = suspect.getPathsComputer().getAllPaths(this.voidListener);
        int n = allPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object path = objectArray[n2];
            dummy.addPath((int[])path);
            ++n2;
        }
        MultiplePathsFromGCRootsClassRecord[] classRecords = dummy.nextLevel();
        int numPaths = allPaths.length;
        double threshold = (double)numPaths * 0.9;
        ArrayList<IClass> referencePattern = new ArrayList<IClass>();
        Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
        MultiplePathsFromGCRootsClassRecord r = classRecords[0];
        while ((double)r.getCount() > threshold) {
            referencePattern.add(r.getClazz());
            classRecords = r.nextLevel();
            if (classRecords == null || classRecords.length == 0) break;
            Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
            r = classRecords[0];
        }
        if (referencePattern.isEmpty()) {
            return null;
        }
        ObjectTreeFactory.TreePathBuilder treeBuilder = new ObjectTreeFactory.TreePathBuilder(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        treeBuilder.addBranch(((IClass)referencePattern.get(0)).getObjectId());
        int i = 1;
        while (i < referencePattern.size()) {
            treeBuilder.addChild(((IClass)referencePattern.get(i)).getObjectId(), false);
            ++i;
        }
        return treeBuilder.build(this.snapshot);
    }

    private List<CompositeResult> findCommonPathForSuspects(HashMap<Integer, List<Integer>> accPoint2ProblemNr) throws SnapshotException {
        ArrayList<CompositeResult> result = new ArrayList<CompositeResult>(2);
        int[] objectIds = new int[accPoint2ProblemNr.size()];
        int j = 0;
        for (Integer accPointId : accPoint2ProblemNr.keySet()) {
            objectIds[j++] = accPointId;
        }
        HashMap<IClass, Set<String>> excludeMap = new HashMap<IClass, Set<String>>();
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.WeakReference", true);
        for (IClass clazz : classes) {
            excludeMap.put(clazz, REFERENCE_FIELD_SET);
        }
        IMultiplePathsFromGCRootsComputer comp = this.snapshot.getMultiplePathsFromGCRoots(objectIds, excludeMap);
        MultiplePathsFromGCRootsRecord[] records = comp.getPathsByGCRoot(this.voidListener);
        Arrays.sort(records, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
        MultiplePathsFromGCRootsRecord[] multiplePathsFromGCRootsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            int[] referencedAccumulationPoints;
            MultiplePathsFromGCRootsRecord rec = multiplePathsFromGCRootsRecordArray[n2];
            if (rec.getCount() < 2) break;
            CompositeResult composite = new CompositeResult(new IResult[0]);
            ArrayList<Integer> problemIds = new ArrayList<Integer>(4);
            int[] nArray = referencedAccumulationPoints = rec.getReferencedObjects();
            int n3 = referencedAccumulationPoints.length;
            int n4 = 0;
            while (n4 < n3) {
                int accPointId = nArray[n4];
                for (Integer problemId : accPoint2ProblemNr.get(accPointId)) {
                    problemIds.add(problemId);
                }
                ++n4;
            }
            Collections.sort(problemIds);
            StringBuilder overview = new StringBuilder(256);
            overview.append("The problem suspects ");
            int k = 0;
            while (k < problemIds.size()) {
                overview.append(problemIds.get(k));
                if (k == problemIds.size() - 2) {
                    overview.append(" and ");
                } else if (k < problemIds.size() - 2) {
                    overview.append(", ");
                }
                ++k;
            }
            overview.append(" may be related, because the reference chains to them have a common beginning.");
            composite.addResult("Overview", (IResult)new TextResult(overview.toString(), true));
            MultiplePathsFromGCRootsRecord parentRecord = rec;
            ArrayIntBig commonPath = new ArrayIntBig();
            while (parentRecord.getCount() == rec.getCount()) {
                commonPath.add(parentRecord.getObjectId());
                MultiplePathsFromGCRootsRecord[] children = parentRecord.nextLevel();
                if (children == null || children.length == 0) break;
                Arrays.sort(children, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
                parentRecord = children[0];
            }
            composite.addResult("Common Path To the Accumulation Point", (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, comp, commonPath.toArray()));
            result.add(composite);
            ++n2;
        }
        return result;
    }

    private int findReferrer(int objectId) throws SnapshotException {
        int n;
        BitField skipped = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        Collection<IClass> classes = this.snapshot.getClassesByName(this.skipPattern, false);
        for (IClass clazz : classes) {
            int[] nArray = clazz.getObjectIds();
            n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int instance = nArray[n2];
                skipped.set(instance);
                ++n2;
            }
        }
        BitField visited = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        LinkedList<int[]> fifo = new LinkedList<int[]>();
        fifo.add(new int[]{objectId});
        while (fifo.size() > 0) {
            int[] e;
            int[] nArray = e = (int[])fifo.removeFirst();
            int n3 = e.length;
            n = 0;
            while (n < n3) {
                int referrer = nArray[n];
                if (!visited.get(referrer)) {
                    if (skipped.get(referrer)) {
                        int[] referrers = this.snapshot.getInboundRefererIds(referrer);
                        fifo.add(referrers);
                        visited.set(referrer);
                    } else {
                        return referrer;
                    }
                }
                ++n;
            }
        }
        return -1;
    }
}

