/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.annotations.Usage;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="OQL")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/oql.gif")
@Usage(value="oql \"select * from ...\"")
@Help(value="Execute an OQL Statement.")
public class OQLQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public String queryString;

    public IOQLQuery.Result execute(IProgressListener listener) throws Exception {
        try {
            IOQLQuery query = SnapshotFactory.createQuery(this.queryString);
            Object result = query.execute(this.snapshot, listener);
            if (result == null) {
                return new OQLTextResult("Your Query did not yield any result.\n\n" + query, this.queryString);
            }
            if (result instanceof IOQLQuery.Result) {
                return (IOQLQuery.Result)result;
            }
            if (result instanceof int[]) {
                return new ObjectListResultImpl(this.snapshot, this.queryString, (int[])result);
            }
            return new OQLTextResult(String.valueOf(result), this.queryString);
        }
        catch (IProgressListener.OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder(256);
            buf.append("Executed Query:\n");
            buf.append(this.queryString);
            Throwable t = null;
            if (e instanceof SnapshotException) {
                buf.append("\n\nProblem reported:\n");
                buf.append(e.getMessage());
                t = e.getCause();
            } else {
                t = e;
            }
            if (t != null) {
                buf.append("\n\n");
                StringWriter w = new StringWriter();
                PrintWriter o = new PrintWriter(w);
                t.printStackTrace(o);
                o.flush();
                buf.append(w.toString());
            }
            return new OQLTextResult(buf.toString(), this.queryString);
        }
    }

    private static class OQLTextResult
    extends TextResult
    implements IOQLQuery.Result {
        String queryString;

        public OQLTextResult(String text, String queryString) {
            super(text);
            this.queryString = queryString;
        }

        public String getOQLQuery() {
            return this.queryString;
        }
    }

    private static class ObjectListResultImpl
    extends ObjectListResult.Outbound
    implements IOQLQuery.Result,
    IResultTree {
        String queryString;

        public ObjectListResultImpl(ISnapshot snapshot, String queryString, int[] objectIds) {
            super(snapshot, objectIds);
            this.queryString = queryString;
        }

        public String getOQLQuery() {
            return this.queryString;
        }
    }
}

