/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;

public class ReferenceQuery {
    public static IResult execute(String adverb, String className, ISnapshot snapshot, IProgressListener listener) throws SnapshotException {
        listener.subTask("Computing Referent Set (objects referenced by the Reference objects)...");
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        Collection<IClass> classes = snapshot.getClassesByName(Pattern.compile(className), true);
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            instanceSet.addAll(objs);
            int ii = 0;
            while (ii < objs.length) {
                IInstance obj = (IInstance)snapshot.getObject(objs[ii]);
                ObjectReference ref = (ObjectReference)obj.getField("referent").getValue();
                if (ref != null) {
                    referentSet.add(ref.getObjectId());
                }
                ++ii;
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        return ReferenceQuery.execute(adverb, instanceSet, referentSet, snapshot, listener);
    }

    public static CompositeResult execute(String adverb, ArrayInt instanceSet, SetInt referentSet, ISnapshot snapshot, IProgressListener listener) throws SnapshotException {
        CompositeResult result = new CompositeResult(new IResult[0]);
        Histogram histogram = snapshot.getHistogram(referentSet.toArray(), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        String l = MessageFormat.format("Histogram of {0} Referenced", adverb);
        histogram.setLabel(l);
        result.addResult(l, (IResult)histogram);
        listener.subTask("Computing retained set of reference set (assuming only the referents are no longer referenced by the Reference objects)...");
        int[] retainedSet = snapshot.getRetainedSet(instanceSet.toArray(), new String[]{"referent"}, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram = snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        l = MessageFormat.format("Only {0} Retained", adverb);
        histogram.setLabel(l);
        result.addResult(l, (IResult)histogram);
        return result;
    }
}

