/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.text.MessageFormat;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Show Retained Set")
@Icon(value="/META-INF/icons/show_retained_set.gif")
@Help(value="Calculate the retained set of an arbitrary set of objects.\n\nOptionally one can provide a list field names. If this parameter is specified, instead of assuming that the whole instance is not available, just the references with the specified name are considered non-existing.")
public class RetainedSetQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, flag="f")
    @Help(value="List of field names")
    public String[] fieldNames;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] retainedSet = this.fieldNames == null ? this.snapshot.getRetainedSet(this.objects.getIds(listener), listener) : this.snapshot.getRetainedSet(this.objects.getIds(listener), this.fieldNames, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Histogram histogram = this.snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(MessageFormat.format("Retained by ''{0}''", this.objects.getLabel()));
        return histogram;
    }
}

