/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Array Fill Ratio")
@Category(value="Java Collections")
@Help(value="Prints a frequency distribution of fill ratios of non-primitive arrays.\n\nThe fill ratio is the proportion of non-null elements in the array. The arrays are then accumulated into as many segments as parameterized.\n\nThis query works only on object arrays because primitive arrays cannot have null values.")
public class ArrayFillRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The array objects. Non-array objects and primitive arrays will be ignored.")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="Number of ranges used for the frequency distribution.")
    public int segments = 5;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask("Extracting fill ratios...");
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)"Fill Ratio", (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column("# Objects", Quantize.COUNT);
        builder.column("Shallow Heap", Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                IObject object;
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                if (this.snapshot.isArray(objectId) && (object = this.snapshot.getObject(objectId)) instanceof IObjectArray) {
                    IObjectArray array = (IObjectArray)object;
                    double fillRatio = 0.0;
                    if (array.getLength() > 0) {
                        fillRatio = (double)CollectionUtil.getNumberOfNoNullArrayElements(array) / (double)array.getLength();
                    }
                    quantize.addValue(objectId, new Object[]{fillRatio, 1, array.getUsedHeapSize()});
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

