/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Arrays Grouped By Size")
@Category(value="Java Collections")
@Help(value="Distribution histogram of given arrays by their size.")
public class ArraysBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The array objects. Non-array objects will be ignored.")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask("Extracting array sizes...");
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column("Length", Integer.TYPE)});
        builder.column("# Objects", Quantize.COUNT);
        builder.column("Shallow Heap", Quantize.SUM_LONG, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                if (this.snapshot.isArray(objectId)) {
                    int size = this.snapshot.getHeapSize(objectId);
                    quantize.addValue(objectId, new Object[]{size, null, size});
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

