/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Collection Fill Ratio")
@Category(value="Java Collections")
@Help(value="Prints a frequency distribution of fill ratios of given collections.\n\nThe below mentioned collections are known to the query. One additional custom collection (e.g. non-JDK) collection can be specified by the 'collection', 'size_attribute' and 'array_attribute' argument.\nKnown collections:\njava.util.ArrayList\njava.util.HashMap\njava.util.Hashtable\njava.util.Properties\njava.util.Vector\njava.util.WeakHashMap\njava.util.concurrent.ConcurrentHashMap$Segment")
public class CollectionFillRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The collection objects. Non-collection objects will be ignored.")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="Number of ranges used for the frequency distribution.")
    public int segments = 5;
    @Argument(isMandatory=false)
    @Help(value="Optional: fully qualified class name of a custom (e.g. non-JDK) collection class.")
    public String collection;
    @Argument(isMandatory=false)
    @Help(value="The size attribute of the (optionally) specified collection class. Must be of type int or Integer.")
    public String size_attribute;
    @Argument(isMandatory=false)
    @Help(value="The array attribute of the (optionally) specified collection class. Must be a Java array.")
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        listener.subTask("Extracting collection fill ratios...");
        HashMap<Integer, CollectionUtil.Info> metadata = new HashMap<Integer, CollectionUtil.Info>();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || !info.hasBackingArray() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), info);
            }
        }
        if (this.collection != null) {
            CollectionUtil.Info info;
            if (this.size_attribute == null || this.array_attribute == null) {
                String msg = "If the collection argument is set to a custom (e.g. non-JDK) collection class, the size_attribute and array_attribute argument must be set. Otherwise, the query cannot calculate the fill ratio.";
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, this.size_attribute, this.array_attribute);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format("Class ''{0}'' not found in heap dump.", this.collection), null);
            }
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), info);
            }
        }
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)"Fill Ratio", (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column("# Objects", Quantize.COUNT);
        builder.column("Shallow Heap", Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    double fillRatio = CollectionFillRatioQuery.getFillRatio(info, obj);
                    quantize.addValue(obj.getObjectId(), new Object[]{fillRatio, 1, obj.getUsedHeapSize()});
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }

    private static double getFillRatio(CollectionUtil.Info info, IObject hashtableObject) throws SnapshotException {
        int size = info.getSize(hashtableObject);
        IObjectArray table = info.getBackingArray(hashtableObject);
        if (table == null || table.getLength() == 0) {
            return 1.0;
        }
        return (double)size / (double)table.getLength();
    }
}

