/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private static Info[] knownCollections = new Info[]{new Info("java.util.AbstractList", null, null), new Info("java.util.ArrayList", -9, "size", "elementData"), new IBM6ArrayListInfo("java.util.ArrayList", 8, "firstIndex", "lastIndex", "array"), new IBM6ArrayListInfo("java.util.ArrayDeque", 8, "front", "rear", "elements"), new Info("java.util.LinkedList", "size", null), new Info("java.util.HashMap", -9, "size", "table", "key", "value"), new Info("java.util.HashMap", 8, "elementCount", "elementData", "key", "value"), new Info("java.util.IdentityHashMap", 6, "size", "table"), new Info("java.util.IdentityHashMap", 8, "size", "elementData"), new Info("java.util.HashSet", -9, "map.size", "map.table", "key", "value"), new Info("java.util.HashSet", 8, "backingMap.elementCount", "backingMap.elementData", "key", "value"), new Info("java.util.TreeMap", "size", null), new Info("java.util.TreeSet", -9, "m.size", null), new Info("java.util.TreeSet", 8, "backingMap.size", null), new Info("java.util.Hashtable", -13, "count", "table", "key", "value"), new Info("java.util.Hashtable", 12, "elementCount", "elementData", "key", "value"), new Info("java.util.Vector", "elementCount", "elementData"), new Info("java.util.WeakHashMap", -9, "size", "table", "referent", "value"), new Info("java.util.WeakHashMap", 8, "elementCount", "elementData", "referent", "value"), new Info("java.util.PriorityQueue", 4, "size", "queue"), new Info("java.util.PriorityQueue", 8, "size", "elements"), new Info("java.lang.ThreadLocal$ThreadLocalMap", 14, "size", "table", "referent", "value"), new Info("java.util.concurrent.ConcurrentHashMap$Segment", "count", "table", "key", "value"), new Info("com.sap.engine.lib.util.AbstractDataStructure", null, null)};

    public static List<Info> getKnownCollections(ISnapshot snapshot) throws SnapshotException {
        int version = CollectionUtil.resolveVersion(snapshot);
        ArrayList<Info> answer = new ArrayList<Info>(knownCollections.length);
        Info[] infoArray = knownCollections;
        int n = knownCollections.length;
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            if ((info.version & version) == version) {
                answer.add(info);
            }
            ++n2;
        }
        return answer;
    }

    public static HashMapIntObject<Info> getKnownMaps(ISnapshot snapshot) throws SnapshotException {
        HashMapIntObject answer = new HashMapIntObject();
        for (Info info : CollectionUtil.getKnownCollections(snapshot)) {
            Collection<IClass> classes;
            if (!info.isMap() || (classes = snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                answer.put(clasz.getObjectId(), (Object)info);
            }
        }
        return answer;
    }

    public static Info getInfo(IObject object) throws SnapshotException {
        List<Info> known = CollectionUtil.getKnownCollections(object.getSnapshot());
        int len = known.size();
        int ii = len - 1;
        while (ii > 0) {
            Info info = known.get(ii);
            if (object.getClazz().doesExtend(info.getClassName())) {
                return info;
            }
            --ii;
        }
        return null;
    }

    public static int getNumberOfNoNullArrayElements(IObjectArray arrayObject) {
        long[] elements = arrayObject.getReferenceArray();
        int result = 0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != 0L) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private CollectionUtil() {
    }

    private static int resolveVersion(ISnapshot snapshot) throws SnapshotException {
        if (snapshot.getClassesByName("com.ibm.oti.vm.AbstractClassLoader$CacheLock", false) != null) {
            return 8;
        }
        if (snapshot.getClassesByName("com.ibm.oti.vm.BootstrapClassLoader", false) != null) {
            return 4;
        }
        if (snapshot.getClassesByName("com.ibm.jvm.Trace", false) != null) {
            return 2;
        }
        return 1;
    }

    private static class IBM6ArrayListInfo
    extends Info {
        private String firstIndex;

        public IBM6ArrayListInfo(String className, int version, String firstIndex, String lastIndex, String arrayField) {
            super(className, version, lastIndex, arrayField);
            this.firstIndex = firstIndex;
        }

        public int getSize(IObject collection) throws SnapshotException {
            int lastIndex = super.getSize(collection);
            if (lastIndex == 0) {
                return 0;
            }
            Integer firstIndex = (Integer)collection.resolveValue(this.firstIndex);
            return lastIndex - (firstIndex == null ? 0 : firstIndex);
        }
    }

    public static class Info {
        private String className;
        private int version;
        private String sizeField;
        private String arrayField;
        private String keyField;
        private String valueField;

        Info(String className, int version, String sizeField, String arrayField) {
            this(className, version, sizeField, arrayField, null, null);
        }

        public Info(String className, String sizeField, String arrayField) {
            this(className, sizeField, arrayField, null, null);
        }

        Info(String className, int version, String sizeField, String arrayField, String keyField, String valueField) {
            this.className = className;
            this.version = version;
            this.sizeField = sizeField;
            this.arrayField = arrayField;
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Info(String className, String sizeField, String arrayField, String keyField, String valueField) {
            this(className, -1, sizeField, arrayField, keyField, valueField);
        }

        public String getClassName() {
            return this.className;
        }

        public boolean hasSize() {
            return this.sizeField != null;
        }

        public int getSize(IObject collection) throws SnapshotException {
            Integer value = (Integer)collection.resolveValue(this.sizeField);
            return value == null ? 0 : value;
        }

        public boolean hasBackingArray() {
            return this.arrayField != null;
        }

        public IObjectArray getBackingArray(IObject collection) throws SnapshotException {
            return (IObjectArray)collection.resolveValue(this.arrayField);
        }

        public String getBackingArrayField() {
            return this.arrayField;
        }

        public boolean isMap() {
            return this.keyField != null;
        }

        public String getEntryKeyField() {
            return this.keyField;
        }

        public String getEntryValueField() {
            return this.valueField;
        }
    }

    private static interface Version {
        public static final int SUN = 1;
        public static final int IBM14 = 2;
        public static final int IBM15 = 4;
        public static final int IBM16 = 8;
    }
}

