/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Collections Grouped By Size")
@Category(value="Java Collections")
@Help(value="Distribution histogram of given collections by their size.\n\nThe below mentioned collections are known to the query. One additional custom collection (e.g. non-JDK) collection can be specified by the 'collection' and 'size_attribute' argument.\nKnown collections:\njava.util.ArrayList\njava.util.TreeMap\njava.util.HashMap\njava.util.Hashtable\njava.util.Properties\njava.util.Vector\njava.util.WeakHashMap\njava.util.concurrent.ConcurrentHashMap$Segment")
public class CollectionsBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The collection objects. Non-collection objects will be ignored.")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="Optional: fully qualified class name of a custom (e.g. non-JDK) collection class.")
    public String collection;
    @Argument(isMandatory=false)
    @Help(value="The size attribute of the (optionally) specified collection class. Must be of type int or Integer.")
    public String size_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        listener.subTask("Collecting collection sizes...");
        HashMapIntObject metadata = new HashMapIntObject();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        if (this.collection != null) {
            CollectionUtil.Info info;
            if (this.size_attribute == null) {
                String msg = "If the collection argument is set to a custom (e.g. non-JDK) collection class, the size_attribute must be set. Otherwise, the query cannot determine the size of the collection.";
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, this.size_attribute, null);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format("Class ''{0}'' not found in heap dump.", this.collection), null);
            }
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column("Length", Integer.TYPE)});
        builder.column("# Objects", Quantize.COUNT);
        builder.column("Shallow Heap", Quantize.SUM_LONG, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        block3: while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    int size = info.getSize(obj);
                    quantize.addValue(objectId, new Object[]{size, null, obj.getUsedHeapSize()});
                }
                if (listener.isCanceled()) break block3;
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

