/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.text.MessageFormat;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Extract List Values")
@CommandName(value="extract_list_values")
@Category(value="Java Collections")
@Help(value="List elements of a LinkedList, ArrayList or Vector object.")
public class ExtractListValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject list;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        CollectionUtil.Info info = CollectionUtil.getInfo(this.list);
        if (info != null && !info.isMap()) {
            if (info.hasBackingArray()) {
                return this.extractArrayList(info, listener);
            }
            if (this.list.getClazz().doesExtend("java.util.LinkedList")) {
                return this.extractLinkedList(info, listener);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Not a (well-known) list: {0}", this.list.getDisplayName()));
    }

    private IResult extractArrayList(CollectionUtil.Info info, IProgressListener listener) throws SnapshotException {
        int size = info.getSize(this.list);
        if (size == 0) {
            return new ObjectListResult.Outbound(this.snapshot, new int[0]);
        }
        String taskMsg = MessageFormat.format("Collecting {0} element(s) of {1}", size, this.list.getTechnicalName());
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        IObjectArray elementData = info.getBackingArray(this.list);
        if (elementData != null) {
            for (NamedReference ref : elementData.getOutboundReferences()) {
                if (ref instanceof PseudoReference) continue;
                result.add(ref.getObjectId());
                listener.worked(1);
            }
        }
        listener.done();
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }

    private IResult extractLinkedList(CollectionUtil.Info info, IProgressListener listener) throws Exception {
        int size = info.getSize(this.list);
        if (size == 0) {
            return new ObjectListResult.Outbound(this.snapshot, new int[0]);
        }
        String taskMsg = MessageFormat.format("collecting {0} element(s) of {1}", size, this.list.getTechnicalName());
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        IObject header = (IObject)this.list.resolveValue("header");
        if (header == null) {
            header = (IObject)this.list.resolveValue("voidLink");
        }
        for (IObject current = (IObject)header.resolveValue("next"); header != current; current = (IObject)current.resolveValue("next")) {
            IObject ref = (IObject)current.resolveValue("element");
            if (ref == null) {
                ref = (IObject)current.resolveValue("data");
            }
            if (ref != null) {
                result.add(ref.getObjectId());
            }
            listener.worked(1);
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        listener.done();
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

