/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.text.MessageFormat;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Extract Hash Set Values")
@CommandName(value="hash_set_values")
@Category(value="Java Collections")
@Help(value="List elements of a HashSet.")
public class HashSetValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject hashSet;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        if (!this.hashSet.getClazz().doesExtend("java.util.HashSet")) {
            throw new IllegalArgumentException(MessageFormat.format("Not a hash set: {0}", this.hashSet.getDisplayName()));
        }
        CollectionUtil.Info info = CollectionUtil.getInfo(this.hashSet);
        ArrayInt hashEntries = new ArrayInt();
        String arrayField = info.getBackingArrayField();
        int p = arrayField.lastIndexOf(46);
        IInstance map = p < 0 ? (IInstance)this.hashSet : (IInstance)this.hashSet.resolveValue(arrayField.substring(0, p));
        Field table = map.getField(p < 0 ? arrayField : arrayField.substring(p + 1));
        int tableObjectId = ((ObjectReference)table.getValue()).getObjectId();
        int[] outbounds = this.snapshot.getOutboundReferentIds(tableObjectId);
        int ii = 0;
        while (ii < outbounds.length) {
            this.collectEntry(hashEntries, outbounds[ii], info, listener);
            ++ii;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return new ObjectListResult.Outbound(this.snapshot, hashEntries.toArray());
    }

    private void collectEntry(ArrayInt hashEntries, int entryId, CollectionUtil.Info info, IProgressListener listener) throws SnapshotException {
        while (entryId >= 0) {
            if (this.snapshot.isClass(entryId)) {
                return;
            }
            IInstance entry = (IInstance)this.snapshot.getObject(entryId);
            entryId = -1;
            Field next = entry.getField("next");
            if (next.getValue() != null) {
                entryId = ((ObjectReference)next.getValue()).getObjectId();
            }
            Field key = entry.getField(info.getEntryKeyField());
            hashEntries.add(((ObjectReference)key.getValue()).getObjectId());
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
    }
}

