/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Map Collision Ratio")
@Category(value="Java Collections")
@Help(value="Prints a frequency distribution of the collistion ratios of map-like collections.\n\nThe below listed map-like collections are known to the query. One additional custom map-like (e.g. non-JDK) collection can be specified by the 'collection', 'size_attribute' and 'array_attribute' argument.\nKnown collections:\njava.util.HashMap\njava.util.Properties\njava.util.Hashtable\njava.util.WeakHashMap\njava.util.concurrent.ConcurrentHashMap$Segment")
public class MapCollisionRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The hashtable objects. Non-hashtable objects will be ignored.")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    @Help(value="Number of segments used for the frequency distribution.")
    public int segments = 5;
    @Argument(isMandatory=false)
    @Help(value="Optional: fully qualified class name of a custom (e.g. non-JDK) map-like collection class.")
    public String collection;
    @Argument(isMandatory=false)
    @Help(value="The size attribute of the (optionally) specified map-like collection. Must be of type int or Integer.")
    public String size_attribute;
    @Argument(isMandatory=false)
    @Help(value="The array attribute of the (optionally) specified map-like collection. Must be a Java array.")
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        listener.subTask("Calculating Map Collision Ratios...");
        HashMapIntObject<CollectionUtil.Info> metadata = CollectionUtil.getKnownMaps(this.snapshot);
        if (this.collection != null) {
            if (this.size_attribute == null || this.array_attribute == null) {
                String msg = "If the collection argument is set to a custom (e.g. non-JDK) collection class, the size_attribute and array_attribute argument must be set. Otherwise, the query cannot calculate the collision ratio.";
                throw new SnapshotException(msg);
            }
            CollectionUtil.Info info = new CollectionUtil.Info(this.collection, this.size_attribute, this.array_attribute);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format("Class ''{0}'' not found in heap dump.", this.collection), null);
            }
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)"Collision Ratio", (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column("# Objects", Quantize.COUNT);
        builder.column("Shallow Heap", Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    double collisionRatio = MapCollisionRatioQuery.getCollisionRatio(info, obj);
                    quantize.addValue(obj.getObjectId(), new Object[]{collisionRatio, null, obj.getUsedHeapSize()});
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }

    private static double getCollisionRatio(CollectionUtil.Info info, IObject hashtableObject) throws SnapshotException {
        int size = info.getSize(hashtableObject);
        if (size == 0) {
            return 0.0;
        }
        IObjectArray table = info.getBackingArray(hashtableObject);
        if (table == null) {
            return 0.0;
        }
        return (double)(size - CollectionUtil.getNumberOfNoNullArrayElements(table)) / (double)size;
    }
}

