/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Finalizer In Processing")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
@Help(value="Extract object currently processed by Finalizer Thread.\n\nFinalizers are executed when the internal garbage collection frees the objects. Due to the lack of control over the finalizer execution, it is recommended to avoid finalizers. Long running tasks in the finalizer can block garbage collection, because the memory can only be freed after the finalize method finished.This query shows the currently processed object by the Finalizer Thread if any.Be aware that there could be many reasons for this object to be currently processed:a.) it could be blocking, b.) it could be long running, or c.) it could be ok,but the queue was or is still full (please use our finalizer queue query to check).")
public class FinalizerInProcessingQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        IObject[] localVars;
        Collection<IClass> finalizerThreadClasses = this.snapshot.getClassesByName("java.lang.ref.Finalizer$FinalizerThread", false);
        if (finalizerThreadClasses == null) {
            throw new Exception("Class java.lang.ref.Finalizer$FinalizerThread not found in heap dump.");
        }
        if (finalizerThreadClasses.size() != 1) {
            throw new Exception("Error: Snapshot contains multiple java.lang.ref.Finalizer$FinalizerThread classes.");
        }
        int[] finalizerThreadObjects = finalizerThreadClasses.iterator().next().getObjectIds();
        if (finalizerThreadObjects == null) {
            throw new Exception("Instance of class java.lang.ref.Finalizer$FinalizerThread not found in heap dump.");
        }
        if (finalizerThreadObjects.length != 1) {
            throw new Exception("Error: Snapshot contains multiple instances of java.lang.ref.Finalizer$FinalizerThread class.");
        }
        SetInt result = new SetInt();
        IObject finalizerThreadObject = this.snapshot.getObject(finalizerThreadObjects[0]);
        IObject[] iObjectArray = localVars = FinalizerInProcessingQuery.getLocalVarsForThread(finalizerThreadObject);
        int n = localVars.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectReference ref;
            IObject object = iObjectArray[n2];
            if ("java.lang.ref.Finalizer".equals(object.getClazz().getName()) && (ref = (ObjectReference)((IInstance)object).getField("referent").getValue()) != null) {
                result.add(ref.getObjectId());
            }
            ++n2;
        }
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }

    private static IObject[] getLocalVarsForThread(IObject thread) throws SnapshotException {
        List<NamedReference> refs = thread.getOutboundReferences();
        ArrayList<IObject> result = new ArrayList<IObject>();
        for (NamedReference ref : refs) {
            if (!(ref instanceof ThreadToLocalReference)) continue;
            result.add(ref.getObject());
        }
        return result.toArray(new IObject[result.size()]);
    }
}

