/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Finalizer Overview")
@Category(value="Java Basics")
@Icon(value="/META-INF/icons/finalizer.gif")
@Help(value="Finalizer Overview.\n\nFinalizers are executed when the internal garbage collection frees the objects. Due to the lack of control over the finalizer execution, it is recommended to avoid finalizers. Long running tasks in the finalizer can block garbage collection, because the memory can only be freed after the finalize method finished.This query shows the the finalizer currently processed, the finalizer queue, the demon finalizer thread and the thread local variables.")
public class FinalizerQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd", "dtfj");
        SectionSpec spec = new SectionSpec("Finalizers");
        IResult result = SnapshotQuery.lookup("finalizer_in_processing", this.snapshot).execute(listener);
        spec.add((Spec)new QuerySpec("In processing by Finalizer Thread", result));
        result = SnapshotQuery.lookup("finalizer_queue", this.snapshot).execute(listener);
        spec.add((Spec)new QuerySpec("Ready for Finalizer Thread", result));
        result = SnapshotQuery.lookup("finalizer_thread", this.snapshot).execute(listener);
        spec.add((Spec)new QuerySpec("Finalizer Thread", result));
        result = SnapshotQuery.lookup("finalizer_thread_locals", this.snapshot).execute(listener);
        spec.add((Spec)new QuerySpec("Finalizer Thread Locals", result));
        return spec;
    }
}

