/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.Collection;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Finalizer Queue")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
@Help(value="Extract objects in the Finalizer Queue.\n\nFinalizers are executed when the internal garbage collection frees the objects. Due to the lack of control over the finalizer execution, it is recommended to avoid finalizers. Long running tasks in the finalizer can block garbage collection, because the memory can only be freed after the finalize method finished.This query shows the objects ready for finalization in their processing order.Be aware that there could be many reasons for a full finalizer queue:a.) the currently processed object could be blocking or long running(please use our finalizer in processing query to check) or the applicationmade use of too many objects with finalize() which are queueing up in memory.")
public class FinalizerQueueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> finalizerClasses = this.snapshot.getClassesByName("java.lang.ref.Finalizer", false);
        if (finalizerClasses == null) {
            throw new Exception("Class java.lang.ref.Finalizer not found in heap dump.");
        }
        if (finalizerClasses.size() != 1) {
            throw new Exception("Error: Snapshot contains multiple java.lang.ref.Finalizer classes.");
        }
        ArrayInt result = new ArrayInt();
        IClass finalizerClass = finalizerClasses.iterator().next();
        IObject queue = (IObject)finalizerClass.resolveValue("queue");
        if (queue == null) {
            return null;
        }
        IInstance item = (IInstance)queue.resolveValue("head");
        int length = ((Long)queue.resolveValue("queueLength")).intValue();
        int threshold = length / 100;
        int worked = 0;
        listener.beginTask("Extracting objects ready for finalization from queue...", length);
        while (item != null) {
            IInstance next;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ObjectReference ref = (ObjectReference)item.getField("referent").getValue();
            if (ref != null) {
                result.add(ref.getObjectId());
            }
            if ((next = (IInstance)item.resolveValue("next")) == item) {
                next = null;
            }
            item = next;
            if (++worked < threshold) continue;
            listener.worked(worked);
            worked = 0;
        }
        listener.done();
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

