/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.Collection;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Finalizer Thread")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
@Help(value="Extract Finalizer Thread.\n\nFinalizers are executed when the internal garbage collection frees the objects. Due to the lack of control over the finalizer execution, it is recommended to avoid finalizers. Long running tasks in the finalizer can block garbage collection, because the memory can only be freed after the finalize method finished.This query shows the daemon thread which is performing the object finalizations.")
public class FinalizerThreadQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> finalizerThreadClasses = this.snapshot.getClassesByName("java.lang.ref.Finalizer$FinalizerThread", false);
        if (finalizerThreadClasses == null) {
            throw new Exception("Class java.lang.ref.Finalizer$FinalizerThread not found in heap dump.");
        }
        if (finalizerThreadClasses.size() != 1) {
            throw new Exception("Error: Snapshot contains multiple java.lang.ref.Finalizer$FinalizerThread classes.");
        }
        int[] finalizerThreadObjects = finalizerThreadClasses.iterator().next().getObjectIds();
        if (finalizerThreadObjects == null) {
            throw new Exception("Instance of class java.lang.ref.Finalizer$FinalizerThread not found in heap dump.");
        }
        if (finalizerThreadObjects.length != 1) {
            throw new Exception("Error: Snapshot contains multiple instances of java.lang.ref.Finalizer$FinalizerThread class.");
        }
        return new ObjectListResult.Outbound(this.snapshot, new int[]{finalizerThreadObjects[0]});
    }
}

