/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.jetty;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@Subject(value="org.mortbay.jetty.Request")
public class JettyRequestResolver
implements IRequestDetailsResolver {
    public void complement(ISnapshot snapshot, IThreadInfo thread, int[] javaLocals, int thisJavaLocal, IProgressListener listener) throws SnapshotException {
        IObject parameters;
        IObject httpRequest = snapshot.getObject(thisJavaLocal);
        IObject requestURI = (IObject)httpRequest.resolveValue("_requestURI");
        if (requestURI == null) {
            return;
        }
        CompositeResult answer = new CompositeResult(new IResult[0]);
        StringBuilder buf = new StringBuilder(256);
        buf.append("The thread is executing an HTTP Request to <strong>").append(requestURI.getClassSpecificName()).append("</strong>.");
        String summary = buf.toString();
        QuerySpec spec = new QuerySpec("Summary");
        spec.setCommand("list_objects 0x" + Long.toHexString(httpRequest.getObjectAddress()));
        spec.setResult((IResult)new TextResult(summary, true));
        answer.addResult((IResult)spec);
        IObject uri = (IObject)httpRequest.resolveValue("_uri._raw");
        if (uri != null) {
            spec = new QuerySpec("URI");
            spec.setCommand("list_objects 0x" + Long.toHexString(uri.getObjectAddress()));
            spec.setResult((IResult)new TextResult(uri.getClassSpecificName()));
            answer.addResult((IResult)spec);
        }
        if ((parameters = (IObject)httpRequest.resolveValue("_parameters")) != null) {
            String cmd = "hash_entries 0x" + Long.toHexString(parameters.getObjectAddress());
            spec = new QuerySpec("Parameters");
            spec.setCommand(cmd);
            spec.setResult(SnapshotQuery.parse(cmd, snapshot).execute(listener));
            spec.set("hide_column", "Collection");
            answer.addResult((IResult)spec);
        }
        thread.addRequest(summary, (IResult)answer);
    }
}

