/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.osgi.model.Bundle;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;
import org.eclipse.mat.inspections.osgi.model.BundleFragment;
import org.eclipse.mat.inspections.osgi.model.IBundleReader;
import org.eclipse.mat.inspections.osgi.model.OSGiModel;
import org.eclipse.mat.inspections.osgi.model.Service;
import org.eclipse.mat.inspections.osgi.model.eclipse.ConfigurationElement;
import org.eclipse.mat.inspections.osgi.model.eclipse.Extension;
import org.eclipse.mat.inspections.osgi.model.eclipse.ExtensionPoint;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxBundleReader
implements IBundleReader {
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private ISnapshot snapshot;
    private Map<BundleDescriptor, List<Service>> registeredServices = new HashMap<BundleDescriptor, List<Service>>();
    private Map<BundleDescriptor, List<Service>> usedServices = new HashMap<BundleDescriptor, List<Service>>();
    private Map<Long, BundleDescriptor> bundleDescriptors = new HashMap<Long, BundleDescriptor>();
    private Map<BundleDescriptor, List<ExtensionPoint>> extensionPointsByBundle = new HashMap<BundleDescriptor, List<ExtensionPoint>>();
    private Map<BundleDescriptor, List<Extension>> extensionsByBundle = new HashMap<BundleDescriptor, List<Extension>>();

    public EquinoxBundleReader(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public OSGiModel readOSGiModel(IProgressListener listener) throws SnapshotException {
        List<BundleDescriptor> descriptors = this.getBundleDescriptors(listener);
        List<Service> services = this.collectServiceInfo(listener);
        List<ExtensionPoint> extensionPoints = this.collectExtensionsInfo(listener);
        OSGiModel model = new OSGiModel(this, descriptors, services, extensionPoints);
        return model;
    }

    private List<BundleDescriptor> getBundleDescriptors(IProgressListener listener) throws SnapshotException {
        listener.subTask("Reading bundles");
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.framework.internal.core.BundleRepository", false);
        ArrayList<BundleDescriptor> bundleDescriptors = new ArrayList<BundleDescriptor>();
        if (classes == null) {
            return bundleDescriptors;
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            int i = 0;
            while (i < objs.length) {
                IInstance obj = (IInstance)this.snapshot.getObject(objs[i]);
                IObjectArray bundlesArray = (IObjectArray)obj.resolveValue("bundlesByInstallOrder.elementData");
                if (bundlesArray == null) {
                    return null;
                }
                long[] bundleAddreses = bundlesArray.getReferenceArray();
                if (bundleAddreses != null) {
                    long[] lArray = bundleAddreses;
                    int n = bundleAddreses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long address = lArray[n2];
                        if (address != 0L) {
                            if (listener.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            int objectId = this.snapshot.mapAddressToId(address);
                            IObject bundleObject = this.snapshot.getObject(objectId);
                            BundleDescriptor.Type type = BundleDescriptor.Type.BUNDLE;
                            if (bundleObject.getClazz().getName().equals("org.eclipse.osgi.framework.internal.core.BundleFragment")) {
                                type = BundleDescriptor.Type.FRAGMENT;
                            }
                            BundleDescriptor descriptor = this.getBundleDescriptor(bundleObject, type);
                            bundleDescriptors.add(descriptor);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return bundleDescriptors;
    }

    private List<BundleDescriptor> getBundleFragments(IObject bundleHostObject) throws SnapshotException {
        IObject fragmentObject = (IObject)bundleHostObject.resolveValue("fragments");
        if (fragmentObject == null) {
            return null;
        }
        if (fragmentObject.getClazz().isArrayType()) {
            long[] addresses = ((IObjectArray)fragmentObject).getReferenceArray();
            ArrayList<BundleDescriptor> fragments = new ArrayList<BundleDescriptor>(addresses.length);
            int i = 0;
            while (i < addresses.length) {
                int id = this.snapshot.mapAddressToId(addresses[i]);
                IObject obj = this.snapshot.getObject(id);
                BundleDescriptor descriptor = this.getBundleDescriptor(obj, BundleDescriptor.Type.FRAGMENT);
                fragments.add(descriptor);
                ++i;
            }
            return fragments;
        }
        MATPlugin.log(MessageFormat.format("Expected array type: 0x{0}", Long.toHexString(fragmentObject.getObjectAddress())));
        return null;
    }

    private List<Service> collectServiceInfo(IProgressListener listener) throws SnapshotException {
        listener.subTask("Reading services");
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.osgi.framework.internal.core.ServiceRegistryImpl", false);
        ArrayList<Service> services = new ArrayList<Service>();
        if (classes == null) {
            return services;
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            int i = 0;
            while (i < objs.length) {
                IInstance obj = (IInstance)this.snapshot.getObject(objs[i]);
                IObjectArray servicesArray = (IObjectArray)obj.resolveValue("allPublishedServices.elementData");
                if (servicesArray == null) {
                    return null;
                }
                long[] serviceAddreses = servicesArray.getReferenceArray();
                if (serviceAddreses != null) {
                    long[] lArray = serviceAddreses;
                    int n = serviceAddreses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long address = lArray[n2];
                        if (address != 0L) {
                            Object bundleInstance;
                            int bundleId;
                            long[] bundleAddresses;
                            if (listener.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            int serviceInstanceId = this.snapshot.mapAddressToId(address);
                            IInstance serviceInstance = (IInstance)this.snapshot.getObject(serviceInstanceId);
                            IObject bundleObj = (IObject)serviceInstance.resolveValue("bundle");
                            BundleDescriptor bundleDescriptor = this.getBundleDescriptor(bundleObj, BundleDescriptor.Type.BUNDLE);
                            ArrayList<BundleDescriptor> bundlesUsing = null;
                            IObjectArray bundlesArray = (IObjectArray)serviceInstance.resolveValue("contextsUsing.elementData");
                            if (bundlesArray != null && (bundleAddresses = bundlesArray.getReferenceArray()) != null) {
                                bundlesUsing = new ArrayList<BundleDescriptor>(bundleAddresses.length);
                                long[] lArray2 = bundleAddresses;
                                int n3 = bundleAddresses.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    long bundleAddress = lArray2[n4];
                                    bundleId = this.snapshot.mapAddressToId(bundleAddress);
                                    bundleInstance = (IInstance)this.snapshot.getObject(bundleId);
                                    IObject bundleObject = (IObject)bundleInstance.resolveValue("bundle");
                                    if (bundleObject != null) {
                                        BundleDescriptor usingBundleDescriptor = this.getBundleDescriptor(bundleObject, BundleDescriptor.Type.BUNDLE);
                                        bundlesUsing.add(usingBundleDescriptor);
                                    }
                                    ++n4;
                                }
                            }
                            IObjectArray clazzes = (IObjectArray)serviceInstance.resolveValue("clazzes");
                            String serviceName = null;
                            if (clazzes != null) {
                                long[] serviceNameArray = clazzes.getReferenceArray();
                                bundleInstance = serviceNameArray;
                                bundleId = serviceNameArray.length;
                                int n5 = 0;
                                while (n5 < bundleId) {
                                    long l = bundleInstance[n5];
                                    try {
                                        int id = this.snapshot.mapAddressToId(l);
                                        IInstance instance = (IInstance)this.snapshot.getObject(id);
                                        serviceName = instance.getClassSpecificName();
                                        break;
                                    }
                                    catch (SnapshotException snapshotException) {
                                        MATPlugin.log(MessageFormat.format("Error reading service's name: 0x{0}", Long.toHexString(l)));
                                        ++n5;
                                    }
                                }
                            }
                            IObject propertiesObject = (IObject)serviceInstance.resolveValue("properties");
                            String[] keys = null;
                            String[] values = null;
                            if (propertiesObject != null) {
                                long[] valueAddresses;
                                IObjectArray valuesArray;
                                long[] keyAddresses;
                                IObjectArray keysArray = (IObjectArray)propertiesObject.resolveValue("headers");
                                if (keysArray != null && (keyAddresses = keysArray.getReferenceArray()) != null) {
                                    keys = this.getServiceProperties(new String[keyAddresses.length], keyAddresses);
                                }
                                if ((valuesArray = (IObjectArray)propertiesObject.resolveValue("values")) != null && (valueAddresses = valuesArray.getReferenceArray()) != null) {
                                    values = this.getServiceProperties(new String[valueAddresses.length], valueAddresses);
                                }
                            }
                            services.add(new Service(serviceName, serviceInstanceId, bundleDescriptor, bundlesUsing, keys, values));
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        if (services.size() > 0) {
            this.updateServiceMap(services);
        }
        return services;
    }

    private String[] getServiceProperties(String[] values, long[] valueAddresses) {
        int j = 0;
        while (j < valueAddresses.length) {
            block6: {
                try {
                    int valueId = this.snapshot.mapAddressToId(valueAddresses[j]);
                    IObject valueObject = this.snapshot.getObject(valueId);
                    if (valueObject == null) break block6;
                    if (valueObject.getClazz().isArrayType()) {
                        long[] addresses = ((IObjectArray)valueObject).getReferenceArray();
                        int k = 0;
                        while (k < addresses.length) {
                            int id = this.snapshot.mapAddressToId(addresses[k]);
                            IObject object = this.snapshot.getObject(id);
                            if (object != null) {
                                values[j] = object.getClassSpecificName();
                                break block6;
                            }
                            ++k;
                        }
                        break block6;
                    }
                    values[j] = valueObject.getClassSpecificName();
                }
                catch (SnapshotException snapshotException) {
                    values[j] = null;
                    MATPlugin.log(MessageFormat.format("Error reading Service property: 0x{0}", Long.toHexString(valueAddresses[j])));
                }
            }
            ++j;
        }
        return values;
    }

    private void updateServiceMap(List<Service> services) {
        for (Service service : services) {
            BundleDescriptor contributedBy = service.getBundleDescriptor();
            this.doUpdate(service, contributedBy, this.registeredServices);
            List<BundleDescriptor> bundlesUsing = service.getBundlesUsing();
            if (bundlesUsing == null) continue;
            for (BundleDescriptor descriptor : bundlesUsing) {
                this.doUpdate(service, descriptor, this.usedServices);
            }
        }
    }

    private void doUpdate(Service service, BundleDescriptor bundleDescriptor, Map<BundleDescriptor, List<Service>> serviceMap) {
        List<Service> listOfServices = serviceMap.get(bundleDescriptor);
        if (listOfServices == null) {
            ArrayList<Service> bundleServices = new ArrayList<Service>(1);
            bundleServices.add(service);
            serviceMap.put(bundleDescriptor, bundleServices);
        } else if (!listOfServices.contains(service)) {
            listOfServices.add(service);
        }
    }

    private BundleDescriptor getBundleDescriptor(IObject bundleHostObject, BundleDescriptor.Type type) throws SnapshotException {
        BundleDescriptor bundleDescriptor;
        IInstance bundleData = (IInstance)bundleHostObject.resolveValue("bundledata");
        Field idField = bundleData.getField("id");
        Long id = null;
        if (idField != null) {
            id = (Long)idField.getValue();
        }
        if ((bundleDescriptor = this.bundleDescriptors.get(id)) != null) {
            return bundleDescriptor;
        }
        String bundleName = this.extractBundleName(bundleData);
        String state = this.getState(bundleHostObject);
        BundleDescriptor descriptor = new BundleDescriptor(bundleHostObject.getObjectId(), id, bundleName, state, type);
        this.bundleDescriptors.put(id, descriptor);
        return descriptor;
    }

    private String extractBundleName(IObject bundleData) throws SnapshotException {
        IObject name = (IObject)bundleData.resolveValue("symbolicName");
        String symbolicName = name.getClassSpecificName();
        IObject versionObj = (IObject)bundleData.resolveValue("version.qualifier.value");
        String version = null;
        if (versionObj != null) {
            version = versionObj.getClassSpecificName();
        }
        String bundleName = version == null || version == "" ? symbolicName : String.valueOf(symbolicName) + " (" + version + ")";
        return bundleName;
    }

    @Override
    public Bundle getBundle(BundleDescriptor descriptor) throws SnapshotException {
        Bundle bundle = this.bundles.get(descriptor.getBundleName());
        if (bundle == null) {
            bundle = this.load(descriptor);
        }
        return bundle;
    }

    private Bundle load(BundleDescriptor descriptor) throws SnapshotException {
        int objectId = descriptor.getObjectId();
        IInstance obj = (IInstance)this.snapshot.getObject(objectId);
        IObject locationObj = (IObject)obj.resolveValue("bundledata.fileName");
        String location = null;
        if (locationObj != null) {
            location = locationObj.getClassSpecificName();
        }
        if (descriptor.getType().equals((Object)BundleDescriptor.Type.FRAGMENT)) {
            BundleDescriptor host = this.getFragmentHost(obj);
            return new BundleFragment(descriptor, location, host);
        }
        List<BundleDescriptor> dependencies = null;
        List<BundleDescriptor> dependents = null;
        IObject bundleDescriptionObject = (IObject)obj.resolveValue("bundledata.bundle.proxy.description");
        if (bundleDescriptionObject != null) {
            IObjectArray resolvedValue = (IObjectArray)bundleDescriptionObject.resolveValue("dependencies.elementData");
            dependencies = this.getDependencies(this.snapshot, resolvedValue);
            IObjectArray resolvedDependentsValue = (IObjectArray)bundleDescriptionObject.resolveValue("dependents.elementData");
            dependents = this.getDependencies(this.snapshot, resolvedDependentsValue);
        }
        List<Extension> extensions = this.extensionsByBundle.get(descriptor);
        List<ExtensionPoint> extensionPoints = this.extensionPointsByBundle.get(descriptor);
        List<Service> registeredServices = this.registeredServices.get(descriptor);
        List<Service> usedServices = this.usedServices.get(descriptor);
        List<BundleDescriptor> fragments = this.getBundleFragments(obj);
        return new Bundle(descriptor, location, dependencies, dependents, extensionPoints, extensions, registeredServices, usedServices, fragments);
    }

    private BundleDescriptor getFragmentHost(IObject bundleFragmentObject) throws SnapshotException {
        IObject fragmentObject = (IObject)bundleFragmentObject.resolveValue("hosts");
        if (fragmentObject == null) {
            return null;
        }
        if (fragmentObject.getClazz().isArrayType()) {
            long[] addresses = ((IObjectArray)fragmentObject).getReferenceArray();
            BundleDescriptor host = null;
            int i = 0;
            while (i < addresses.length) {
                int id = this.snapshot.mapAddressToId(addresses[i]);
                IObject bundleLoaderObject = this.snapshot.getObject(id);
                IObject bundleObject = (IObject)bundleLoaderObject.resolveValue("bundle");
                host = this.getBundleDescriptor(bundleObject, BundleDescriptor.Type.BUNDLE);
                ++i;
            }
            return host;
        }
        MATPlugin.log(MessageFormat.format("Expected array type: 0x{0}", Long.toHexString(fragmentObject.getObjectAddress())));
        return null;
    }

    private String getState(IObject obj) throws SnapshotException {
        IInstance bundleHostObject = (IInstance)obj.resolveValue("bundledata.bundle");
        Field stateField = bundleHostObject.getField("state");
        if (stateField == null) {
            return "N/A";
        }
        int state = (Integer)stateField.getValue();
        BundleState[] bundleStateArray = BundleState.values();
        int n = bundleStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleState stateType = bundleStateArray[n2];
            if (stateType.getValue() == state) {
                return stateType.getLabel();
            }
            ++n2;
        }
        return "N/A";
    }

    private List<BundleDescriptor> getDependencies(ISnapshot snapshot, IObjectArray resolvedValue) throws SnapshotException {
        long[] dependencyAddreses;
        ArrayList<BundleDescriptor> dependencyDescriptors = null;
        if (resolvedValue != null && (dependencyAddreses = resolvedValue.getReferenceArray()) != null) {
            dependencyDescriptors = new ArrayList<BundleDescriptor>(dependencyAddreses.length);
            long[] lArray = dependencyAddreses;
            int n = dependencyAddreses.length;
            int n2 = 0;
            while (n2 < n) {
                long address = lArray[n2];
                int objectId = snapshot.mapAddressToId(address);
                IObject bundleDescriptionObject = snapshot.getObject(objectId);
                IObject bundleHostObject = (IObject)bundleDescriptionObject.resolveValue("userObject.bundle");
                if (bundleHostObject != null) {
                    BundleDescriptor.Type type = BundleDescriptor.Type.BUNDLE;
                    if (bundleHostObject.getClazz().getName().equals("org.eclipse.osgi.framework.internal.core.BundleFragment")) {
                        type = BundleDescriptor.Type.FRAGMENT;
                    }
                    BundleDescriptor descriptor = this.getBundleDescriptor(bundleHostObject, type);
                    dependencyDescriptors.add(descriptor);
                }
                ++n2;
            }
        }
        return dependencyDescriptors;
    }

    private List<ExtensionPoint> collectExtensionsInfo(IProgressListener listener) throws SnapshotException {
        listener.subTask("Reading extensions");
        Collection<IClass> classes = this.snapshot.getClassesByName("org.eclipse.core.internal.registry.ExtensionRegistry", false);
        if (classes == null) {
            return null;
        }
        HashMap<String, ExtensionPoint> extensionPoints = new HashMap<String, ExtensionPoint>();
        HashMap<Integer, Extension> extensions = new HashMap<Integer, Extension>();
        HashMap<Integer, ConfigurationElement> configElements = new HashMap<Integer, ConfigurationElement>();
        for (IClass clazz : classes) {
            Object objs = clazz.getObjectIds();
            int n = 0;
            while (n < ((Object)objs).length) {
                long[] heldObjectAddreses;
                IInstance iInstance = (IInstance)this.snapshot.getObject((int)objs[n]);
                IObjectArray heldObjectsArray = (IObjectArray)iInstance.resolveValue("registryObjects.heldObjects.elements");
                if (heldObjectsArray != null && (heldObjectAddreses = heldObjectsArray.getReferenceArray()) != null) {
                    long[] lArray = heldObjectAddreses;
                    int n2 = heldObjectAddreses.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        long address = lArray[n3];
                        if (address != 0L) {
                            if (listener.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            int objectId = this.snapshot.mapAddressToId(address);
                            IObject instance = this.snapshot.getObject(objectId);
                            String className = instance.getClazz().getName();
                            if (className.equals("org.eclipse.core.internal.registry.ExtensionPoint")) {
                                ExtensionPoint extensionPoint = this.extractExtensionPointInfo(instance);
                                if (extensionPoint != null && !extensionPoints.containsValue(extensionPoint)) {
                                    extensionPoints.put(extensionPoint.getName(), extensionPoint);
                                } else if (extensionPoint != null) {
                                    MATPlugin.log(MessageFormat.format(" Duplicate extension point: {0}", extensionPoint.getName()));
                                }
                            } else if (className.equals("org.eclipse.core.internal.registry.ConfigurationElement")) {
                                ConfigurationElement configElement = this.extractConfigurationElementInfo(instance);
                                if (configElement != null && !configElements.containsValue(configElement)) {
                                    configElements.put(configElement.getElementId(), configElement);
                                } else if (configElement != null) {
                                    MATPlugin.log(MessageFormat.format(" Duplicate configuration element: {0}, objectId: {1}", configElement.getName(), configElement.getObjectId()));
                                }
                            } else if (className.equals("org.eclipse.core.internal.registry.Extension")) {
                                Extension extension2 = this.extractExtensionInfo(instance);
                                if (extension2 != null && !extensions.containsValue(extension2)) {
                                    extensions.put(extension2.getExtensionId(), extension2);
                                } else if (extension2 != null) {
                                    MATPlugin.log(MessageFormat.format(" Duplicate extension: {0}", extension2.getName()));
                                }
                            } else {
                                MATPlugin.log(MessageFormat.format("Unknown element type: 0x{0}", Long.toHexString(address)));
                            }
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
        Set configElementSet = configElements.entrySet();
        for (Map.Entry entry : configElementSet) {
            ConfigurationElement configurationElement = (ConfigurationElement)entry.getValue();
            Extension extension = (Extension)extensions.get(configurationElement.getParentId());
            if (extension == null) {
                ConfigurationElement configElement = (ConfigurationElement)configElements.get(configurationElement.getParentId());
                if (configElement == null) continue;
                configElement.addConfigurationElement(configurationElement);
                continue;
            }
            extension.addConfigurationElement(configurationElement);
        }
        Set set = extensions.entrySet();
        for (Map.Entry entry : set) {
            Extension extension = (Extension)entry.getValue();
            String name = extension.getName();
            ExtensionPoint extensionPoint = (ExtensionPoint)extensionPoints.get(name);
            if (extensionPoint == null) continue;
            extensionPoint.addExtension(extension);
        }
        Set extensionsSet = extensions.entrySet();
        for (Map.Entry entry : extensionsSet) {
            Extension extension3 = (Extension)entry.getValue();
            BundleDescriptor bundleDescriptor = extension3.getContributedBy();
            List<Extension> listOfExtensions = this.extensionsByBundle.get(bundleDescriptor);
            if (listOfExtensions == null) {
                ArrayList<Object> extensionList = new ArrayList<Object>(1);
                extensionList.add(extension3);
                this.extensionsByBundle.put(bundleDescriptor, extensionList);
                continue;
            }
            if (listOfExtensions.contains(extension3)) continue;
            listOfExtensions.add(extension3);
        }
        Set set2 = extensionPoints.entrySet();
        for (Map.Entry entry : set2) {
            ExtensionPoint point = (ExtensionPoint)entry.getValue();
            BundleDescriptor bundleDescriptor = point.getContributedBy();
            List<ExtensionPoint> listOfExtensions = this.extensionPointsByBundle.get(bundleDescriptor);
            if (listOfExtensions == null) {
                ArrayList<ExtensionPoint> bundleExtensions = new ArrayList<ExtensionPoint>(1);
                bundleExtensions.add(point);
                this.extensionPointsByBundle.put(bundleDescriptor, bundleExtensions);
                continue;
            }
            if (listOfExtensions.contains(point)) continue;
            listOfExtensions.add(point);
        }
        Set<Map.Entry<BundleDescriptor, List<ExtensionPoint>>> set3 = this.extensionPointsByBundle.entrySet();
        ArrayList<ExtensionPoint> points = new ArrayList<ExtensionPoint>();
        for (Map.Entry<BundleDescriptor, List<ExtensionPoint>> entry : set3) {
            List<ExtensionPoint> list = entry.getValue();
            for (ExtensionPoint extensionPoint : list) {
                if (points.contains(extensionPoint)) continue;
                points.add(extensionPoint);
            }
        }
        return points;
    }

    private ConfigurationElement extractConfigurationElementInfo(IObject instance) throws SnapshotException {
        Field idField = ((IInstance)instance).getField("parentId");
        if (idField == null) {
            MATPlugin.log(MessageFormat.format("Expected field parentId: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        Integer parentId = (Integer)idField.getValue();
        Field objectIdField = ((IInstance)instance).getField("objectId");
        if (objectIdField == null) {
            MATPlugin.log(MessageFormat.format("Expected field objectId: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        Integer objectId = (Integer)objectIdField.getValue();
        IObject contributorObject = (IObject)instance.resolveValue("contributorId");
        if (contributorObject == null) {
            MATPlugin.log(MessageFormat.format("Expected contributorId: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        BundleDescriptor contributedBy = this.bundleDescriptors.get(Long.valueOf(contributorObject.getClassSpecificName()));
        IObject nameObject = (IObject)instance.resolveValue("name");
        if (nameObject == null) {
            return null;
        }
        String name = nameObject.getClassSpecificName();
        IObject propertiesObject = (IObject)instance.resolveValue("propertiesAndValue");
        if (propertiesObject == null) {
            MATPlugin.log(MessageFormat.format("Expected propertiesAndValues: 0x{0}", Long.toHexString(instance.getObjectAddress())));
        } else {
            if (propertiesObject.getClazz().isArrayType()) {
                long[] addresses = ((IObjectArray)propertiesObject).getReferenceArray();
                String[] propertiesAndValues = new String[addresses.length];
                int i = 0;
                while (i < addresses.length) {
                    try {
                        int id = this.snapshot.mapAddressToId(addresses[i]);
                        IObject object = this.snapshot.getObject(id);
                        propertiesAndValues[i] = object.getClassSpecificName();
                    }
                    catch (SnapshotException snapshotException) {
                        MATPlugin.log(MessageFormat.format("Error reading property of ConfigurationElement: 0x{0}", Long.toHexString(addresses[i])));
                        propertiesAndValues[i] = null;
                    }
                    ++i;
                }
                return new ConfigurationElement(instance.getObjectId(), name, parentId, objectId, contributedBy, propertiesAndValues);
            }
            MATPlugin.log(MessageFormat.format("Expected propertiesAndValues in String[] format: 0x{0}", Long.toHexString(instance.getObjectAddress())));
        }
        return new ConfigurationElement(instance.getObjectId(), name, parentId, objectId, contributedBy, null);
    }

    private Extension extractExtensionInfo(IObject instance) throws SnapshotException {
        String[] properties = this.getExtensionProperties(instance);
        if (properties == null) {
            return null;
        }
        Field id = ((IInstance)instance).getField("objectId");
        if (id == null) {
            MATPlugin.log(MessageFormat.format("Expected field objectId: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        Integer extensionId = (Integer)id.getValue();
        Extension extension = new Extension(instance.getObjectId(), extensionId, properties);
        BundleDescriptor contributedBy = this.bundleDescriptors.get(Long.valueOf(extension.getContributorId()));
        extension.setContributedBy(contributedBy);
        return extension;
    }

    private String[] getExtensionProperties(IObject instance) throws SnapshotException {
        IObject extraInfoObject = (IObject)instance.resolveValue("extraInformation");
        if (extraInfoObject == null) {
            MATPlugin.log(MessageFormat.format("Expected extraInformation: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        if (extraInfoObject.getClazz().isArrayType()) {
            long[] addresses = ((IObjectArray)extraInfoObject).getReferenceArray();
            String[] properties = new String[addresses.length];
            int i = 0;
            while (i < addresses.length) {
                int id = this.snapshot.mapAddressToId(addresses[i]);
                IObject object = this.snapshot.getObject(id);
                properties[i] = object.getClassSpecificName();
                ++i;
            }
            return properties;
        }
        IObject referentObject = (IObject)extraInfoObject.resolveValue("referent");
        if (referentObject != null) {
            MATPlugin.log(MessageFormat.format("Extension 0x{0} has properties in the form of SoftReference. Not handled.", Long.toHexString(instance.getObjectAddress())));
        }
        return null;
    }

    private ExtensionPoint extractExtensionPointInfo(IObject instance) throws SnapshotException {
        String[] properties = this.getExtensionProperties(instance);
        if (properties == null) {
            return null;
        }
        Field id = ((IInstance)instance).getField("objectId");
        if (id == null) {
            MATPlugin.log(MessageFormat.format("Expected field objectId: 0x{0}", Long.toHexString(instance.getObjectAddress())));
            return null;
        }
        Integer extensionPointId = (Integer)id.getValue();
        ExtensionPoint extensionPoint = new ExtensionPoint(instance.getObjectId(), extensionPointId, properties);
        BundleDescriptor contributedBy = this.bundleDescriptors.get(Long.valueOf(extensionPoint.getContributorId()));
        extensionPoint.setContributedBy(contributedBy);
        return extensionPoint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BundleState {
        ACTIVE("active", 32),
        INSTALLED("installed", 2),
        RESOLVED("resolved", 4),
        STARTING("starting", 8),
        STOPPING("stopping", 16),
        UNINSTALLED("uninstalled", 1);

        private String label;
        private int value;

        private BundleState(String label, int value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public int getValue() {
            return this.value;
        }
    }
}

