/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.threads.ThreadInfoImpl;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@Name(value="Thread Overview")
@Category(value="Java Basics")
@Icon(value="/META-INF/icons/threads.gif")
public class ThreadOverviewQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask("Searching Threads...");
        ArrayList<ThreadInfoImpl> result = new ArrayList<ThreadInfoImpl>();
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.Thread", true);
        for (IClass clasz : classes) {
            int[] nArray = clasz.getObjectIds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                result.add(ThreadInfoImpl.build(this.snapshot.getObject(id), false, listener));
                ++n2;
            }
        }
        Collections.sort(result, new Comparator<ThreadInfoImpl>(){

            @Override
            public int compare(ThreadInfoImpl o1, ThreadInfoImpl o2) {
                return o1.getRetainedHeap() > o2.getRetainedHeap() ? -1 : (o1.getRetainedHeap() == o2.getRetainedHeap() ? 0 : 1);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return new ThreadInfoList(this.snapshot, result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadInfoList
    implements IResultTable,
    IIconProvider {
        ISnapshot snapshot;
        List<ThreadInfoImpl> infos;
        Column[] columns;

        public ThreadInfoList(ISnapshot snapshot, List<ThreadInfoImpl> infos) {
            this.snapshot = snapshot;
            this.infos = infos;
            this.columns = ThreadInfoImpl.getColumns().toArray(new Column[0]);
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addDetailResult(new DetailResultProvider("Thread Details"){

                public boolean hasResult(Object row) {
                    try {
                        InspectionAssert.heapFormatIsNot(ThreadInfoList.this.snapshot, "phd");
                        return true;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        return false;
                    }
                }

                public IResult getResult(Object row, IProgressListener listener) throws SnapshotException {
                    int threadId = ((ThreadInfoImpl)row).getThreadId();
                    return SnapshotQuery.lookup("thread_details", ThreadInfoList.this.snapshot).set("threadIds", threadId).execute(listener);
                }
            }).build();
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public Object getRow(int rowId) {
            return this.infos.get(rowId);
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ThreadInfoImpl info = (ThreadInfoImpl)row;
            return info.getValue(this.columns[columnIndex]);
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((ThreadInfoImpl)row).getThreadId();
                }
            };
        }

        public int getRowCount() {
            return this.infos.size();
        }

        public URL getIcon(Object row) {
            return Icons.forObject(this.snapshot, ((ThreadInfoImpl)row).getThreadId());
        }
    }
}

