/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.snapshot.SnapshotQueryContext;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.report.TestSuite;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.util.ConsoleProgressListener;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseSnapshotApp
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Usage: <snapshot> [(<report id>)*]");
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            throw new FileNotFoundException(MessageFormat.format("File not found: {0}", file.getAbsolutePath()));
        }
        ArrayList<Spec> reports = new ArrayList<Spec>();
        SpecFactory factory = SpecFactory.instance();
        int ii = 1;
        while (ii < args.length) {
            Spec spec = null;
            File specFile = new File(args[ii]);
            spec = specFile.exists() ? factory.create(specFile) : factory.create(args[ii]);
            if (spec != null) {
                factory.resolve(spec);
                reports.add(spec);
            } else {
                System.err.println(MessageFormat.format("Report not found: {0}", args[ii]));
            }
            ++ii;
        }
        this.parse(file, reports);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private void parse(File file, List<Spec> reports) throws SnapshotException {
        ConsoleProgressListener listener = new ConsoleProgressListener((OutputStream)System.out);
        ISnapshot snapshot = SnapshotFactory.openSnapshot(file, (IProgressListener)listener);
        listener.done();
        try {
            for (Spec report : reports) {
                try {
                    this.runReport(snapshot, report);
                }
                catch (SnapshotException e) {
                    MATPlugin.log(e);
                }
                catch (IOException e) {
                    MATPlugin.log(e);
                }
            }
        }
        finally {
            SnapshotFactory.dispose(snapshot);
        }
    }

    private void runReport(ISnapshot snapshot, Spec report) throws SnapshotException, IOException {
        TestSuite suite = new TestSuite.Builder(report).build((IQueryContext)new SnapshotQueryContext(snapshot));
        ConsoleProgressListener listener = new ConsoleProgressListener((OutputStream)System.out);
        suite.execute((IProgressListener)listener);
        listener.done();
    }
}

