/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public abstract class HeapObjectArgumentFactory
implements ArgumentFactory {
    protected final ISnapshot snapshot;

    public static final ArgumentFactory build(ISnapshot snapshot, int[] objectIds) {
        return new AsIntegerImpl(snapshot, objectIds);
    }

    public static final ArgumentFactory build(ISnapshot snapshot, IHeapObjectArgument argument) {
        return new AsObjectArgumentImpl(snapshot, argument, "[objects]");
    }

    protected HeapObjectArgumentFactory(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Object build(ArgumentDescriptor argument) throws SnapshotException {
        try {
            if (IHeapObjectArgument.class.isAssignableFrom(argument.getType())) {
                IHeapObjectArgument value = this.asObjectArgument();
                if (argument.isArray()) {
                    Object array = Array.newInstance(argument.getType(), 1);
                    Array.set(array, 0, value);
                    return array;
                }
                if (argument.isList()) {
                    ArrayList<IHeapObjectArgument> list = new ArrayList<IHeapObjectArgument>(1);
                    list.add(value);
                    return list;
                }
                return value;
            }
            int[] objectIds = this.asIntegerArray();
            return this.assignObjectIds(argument, this.snapshot, objectIds);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SnapshotException(MessageFormat.format("{0}: Error setting heap objects to field ''{1}''", e.getClass().getCanonicalName(), argument.getName()), (Throwable)e);
        }
    }

    private Object assignObjectIds(ArgumentDescriptor argument, ISnapshot snapshot, int[] objectIds) throws IllegalArgumentException, SnapshotException {
        if (argument.isArray()) {
            if (argument.getType() == Integer.TYPE) {
                return objectIds;
            }
            if (argument.getType() == Integer.class) {
                Object array = Array.newInstance(argument.getType(), objectIds.length);
                int ii = 0;
                while (ii < objectIds.length) {
                    Array.set(array, ii, objectIds[ii]);
                    ++ii;
                }
                return array;
            }
            if (IObject.class.isAssignableFrom(argument.getType())) {
                Object array = Array.newInstance(argument.getType(), objectIds.length);
                int ii = 0;
                while (ii < objectIds.length) {
                    Array.set(array, ii, snapshot.getObject(objectIds[ii]));
                    ++ii;
                }
                return array;
            }
            throw new SnapshotException();
        }
        if (argument.isList()) {
            if (argument.getType() == Integer.class) {
                ArrayList<Integer> list = new ArrayList<Integer>(objectIds.length);
                int ii = 0;
                while (ii < objectIds.length) {
                    list.add(objectIds[ii]);
                    ++ii;
                }
                return list;
            }
            if (IObject.class.isAssignableFrom(argument.getType())) {
                ArrayList<IObject> list = new ArrayList<IObject>(objectIds.length);
                int ii = 0;
                while (ii < objectIds.length) {
                    list.add(snapshot.getObject(objectIds[ii]));
                    ++ii;
                }
                return list;
            }
            throw new SnapshotException(MessageFormat.format("Type ''{0}'' of argument ''{1}'' not supported.", argument.getType().getName(), argument.getName()));
        }
        if (objectIds.length != 1) {
            throw new SnapshotException(MessageFormat.format("Argument ''{0}'' does not allow to assign multiple objects", argument.getName()));
        }
        if (argument.getType() == Integer.TYPE) {
            return objectIds[0];
        }
        if (argument.getType() == Integer.class) {
            return objectIds[0];
        }
        if (IObject.class.isAssignableFrom(argument.getType())) {
            return snapshot.getObject(objectIds[0]);
        }
        throw new SnapshotException(MessageFormat.format("Type ''{0}'' of argument ''{1}'' not supported.", argument.getType().getName(), argument.getName()));
    }

    protected abstract int[] asIntegerArray() throws SnapshotException;

    protected abstract IHeapObjectArgument asObjectArgument();

    private static class AsIntegerImpl
    extends HeapObjectArgumentFactory {
        private final int[] objectIds;

        public AsIntegerImpl(ISnapshot snapshot, int[] objectIds) {
            super(snapshot);
            this.objectIds = objectIds;
        }

        public void appendUsage(StringBuilder buf) {
            buf.append("[objects]");
        }

        protected IHeapObjectArgument asObjectArgument() {
            return new IHeapObjectArgument(){

                @Override
                public int[] getIds(IProgressListener listener) throws SnapshotException {
                    return AsIntegerImpl.this.objectIds;
                }

                @Override
                public String getLabel() {
                    return "Objects";
                }

                @Override
                public Iterator<int[]> iterator() {
                    return new Iterator<int[]>(){
                        boolean done = false;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public int[] next() {
                            this.done = true;
                            return AsIntegerImpl.this.objectIds;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        protected int[] asIntegerArray() {
            return this.objectIds;
        }
    }

    private static class AsObjectArgumentImpl
    extends HeapObjectArgumentFactory {
        private final IHeapObjectArgument hoa;
        private final String label;

        public AsObjectArgumentImpl(ISnapshot snapshot, IHeapObjectArgument hoa, String label) {
            super(snapshot);
            this.hoa = hoa;
            this.label = label;
        }

        public void appendUsage(StringBuilder buf) {
            buf.append(this.label);
        }

        protected IHeapObjectArgument asObjectArgument() {
            return this.hoa;
        }

        protected int[] asIntegerArray() throws SnapshotException {
            return this.hoa.getIds((IProgressListener)new VoidProgressListener());
        }
    }
}

