/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.internal.snapshot.HeapObjectArgumentFactory;
import org.eclipse.mat.query.registry.Converters;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeapObjectParamArgument
extends HeapObjectArgumentFactory {
    private boolean isRetained = false;
    private boolean includeSubclasses = false;
    private boolean includeClassInstance = false;
    private boolean includeLoadedInstances = false;
    private boolean isVerbose = false;
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private List<Long> addresses = new ArrayList<Long>();
    private List<String> oqls = new ArrayList<String>();

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        for (Pattern p : this.patterns) {
            buf.append(Converters.convertAndEscape(Pattern.class, (Object)p)).append(" ");
        }
        for (Long a : this.addresses) {
            buf.append("0x").append(Long.toHexString(a)).append(" ");
        }
        for (String o : this.oqls) {
            buf.append(this.escape(o)).append(";").append(" ");
        }
        if (this.includeClassInstance) {
            buf.append(" -include_class_instance");
        }
        if (this.includeSubclasses) {
            buf.append(" -include_subclasses");
        }
        if (this.includeLoadedInstances) {
            buf.append(" -include_loaded_instances");
        }
        if (this.isRetained) {
            buf.append(" -retained");
        }
        if (this.isVerbose) {
            buf.append(" -verbose");
        }
        return buf.toString();
    }

    public HeapObjectParamArgument(ISnapshot snapshot) {
        super(snapshot);
    }

    @Override
    protected int[] asIntegerArray() throws SnapshotException {
        return this.create().getIds((IProgressListener)new VoidProgressListener());
    }

    @Override
    protected IHeapObjectArgument asObjectArgument() {
        return this.create();
    }

    public void appendUsage(StringBuilder buf) {
        buf.append(this.toString());
    }

    private String escape(String query) {
        int p = query.indexOf(34);
        if (p < 0) {
            return query;
        }
        StringBuilder buf = new StringBuilder(query.length() + 5);
        int ii = 0;
        while (ii < query.length()) {
            char c = query.charAt(ii);
            if (c == '\"') {
                buf.append("\\");
            }
            buf.append(c);
            ++ii;
        }
        return buf.toString();
    }

    public boolean isIncludeSubclasses() {
        return this.includeSubclasses;
    }

    public void setIncludeSubclasses(boolean includeSubclasses) {
        this.includeSubclasses = includeSubclasses;
    }

    public boolean isIncludeClassInstance() {
        return this.includeClassInstance;
    }

    public void setIncludeClassInstance(boolean includeClassInstance) {
        this.includeClassInstance = includeClassInstance;
    }

    public boolean isIncludeLoadedInstances() {
        return this.includeLoadedInstances;
    }

    public void setIncludeLoadedInstances(boolean includeLoadedInstances) {
        this.includeLoadedInstances = includeLoadedInstances;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public void setRetained(boolean isRetained) {
        this.isRetained = isRetained;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void addObjectAddress(long address) {
        this.addresses.add(address);
    }

    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public void addOql(String query) {
        this.oqls.add(query);
    }

    public List<Object> getArguments() {
        ArrayList<Object> answer = new ArrayList<Object>();
        answer.addAll(this.patterns);
        answer.addAll(this.addresses);
        answer.addAll(this.oqls);
        return answer;
    }

    public boolean isComplete() {
        return !this.patterns.isEmpty() || !this.addresses.isEmpty() || !this.oqls.isEmpty();
    }

    public IHeapObjectArgument create() {
        return new IHeapObjectArgument(){

            @Override
            public int[] getIds(IProgressListener listener) throws SnapshotException {
                ArrayIntBig answer = new ArrayIntBig();
                for (int[] a : this) {
                    answer.addAll(a);
                }
                return answer.toArray();
            }

            @Override
            public Iterator<int[]> iterator() {
                return new IteratorImpl(HeapObjectParamArgument.this.snapshot, HeapObjectParamArgument.this);
            }

            @Override
            public String getLabel() {
                return HeapObjectParamArgument.this.toString();
            }
        };
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public List<Long> getAddresses() {
        return this.addresses;
    }

    public List<String> getOqls() {
        return this.oqls;
    }

    public static interface Flags {
        public static final String INCLUDE_SUBCLASSES = "-include_subclasses";
        public static final String INCLUDE_CLASS_INSTANCE = "-include_class_instance";
        public static final String INCLUDE_LOADED_INSTANCES = "-include_loaded_instances";
        public static final String VERBOSE = "-verbose";
        public static final String RETAINED = "-retained";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorImpl
    implements Iterator<int[]> {
        Logger logger;
        ISnapshot snapshot;
        HeapObjectParamArgument hopa;
        LinkedList<Object> arguments;
        int[] next;

        public IteratorImpl(ISnapshot snapshot, HeapObjectParamArgument hopa) {
            this.snapshot = snapshot;
            this.hopa = hopa;
            this.arguments = new LinkedList<Object>(hopa.getArguments());
            if (hopa.isVerbose) {
                this.logger = Logger.getLogger(this.getClass().getName());
            }
            this.next = hopa.isRetained ? this.getAll() : this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public int[] next() {
            int[] answer = this.next;
            this.next = this.getNext();
            return answer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int[] getNext() {
            if (this.arguments.isEmpty()) {
                return null;
            }
            try {
                Object argument = this.arguments.removeFirst();
                if (argument instanceof Pattern) {
                    return this.collectObjectsByPattern((Pattern)argument);
                }
                if (argument instanceof Long) {
                    return this.collectObjectsByAddress((Long)argument);
                }
                if (argument instanceof String) {
                    return this.collectObjectsByOQL((String)argument);
                }
                throw new SnapshotException("Unknown argument type:" + argument.getClass().getName());
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        private int[] getAll() {
            try {
                ArrayInt objectIds = new ArrayInt();
                int[] batch = this.getNext();
                while (batch != null) {
                    objectIds.addAll(batch);
                    batch = this.getNext();
                }
                return this.snapshot.getRetainedSet(objectIds.toArray(), (IProgressListener)new VoidProgressListener());
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        private int[] collectObjectsByPattern(Pattern pattern) throws SnapshotException {
            int[] answer;
            Collection<IClass> classesByName;
            if (this.hopa.isVerbose) {
                this.logger.log(Level.INFO, MessageFormat.format("Looking up objects for class name pattern ''{0}''", pattern.toString()));
            }
            if ((classesByName = this.snapshot.getClassesByName(pattern, this.hopa.includeSubclasses)).size() == 1) {
                IClass clazz = classesByName.iterator().next();
                answer = clazz.getObjectIds();
                if (this.hopa.isVerbose) {
                    this.logger.log(Level.INFO, MessageFormat.format("Added class {0} and {1} instances of it", clazz.getName(), answer.length));
                }
                if (this.hopa.includeClassInstance) {
                    int[] addtl = new int[answer.length + 1];
                    addtl[0] = clazz.getObjectId();
                    System.arraycopy(answer, 0, addtl, 1, answer.length);
                    answer = addtl;
                }
            } else {
                int classCount = 0;
                int instanceCount = 0;
                ArrayInt objIds = new ArrayInt();
                for (IClass clazz : classesByName) {
                    if (this.hopa.includeClassInstance) {
                        objIds.add(clazz.getObjectId());
                    }
                    int[] toAdd = clazz.getObjectIds();
                    objIds.addAll(toAdd);
                    ++classCount;
                    instanceCount += toAdd.length;
                    if (!this.hopa.isVerbose) continue;
                    this.logger.log(Level.INFO, MessageFormat.format("Added class {0} and {1} instances of it", clazz.getName(), toAdd.length));
                }
                if (this.hopa.isVerbose) {
                    this.logger.log(Level.INFO, MessageFormat.format("{0} classes ({1} instances) are matching the pattern", classCount, instanceCount));
                }
                answer = objIds.toArray();
            }
            return this.evalLoaderInstances(answer);
        }

        private int[] collectObjectsByAddress(long address) throws SnapshotException {
            int objectId = this.snapshot.mapAddressToId(address);
            if (objectId < 0) {
                throw new SnapshotException(MessageFormat.format("Object 0x{0} not found", Long.toHexString(address)));
            }
            return this.evalIncludeSubClassesAndInstances(new int[]{objectId});
        }

        private int[] collectObjectsByOQL(String queryString) throws OQLParseException, SnapshotException {
            IOQLQuery oqlQuery = SnapshotFactory.createQuery(queryString);
            Object result = oqlQuery.execute(this.snapshot, (IProgressListener)new VoidProgressListener());
            if (result instanceof int[]) {
                return this.evalIncludeSubClassesAndInstances((int[])result);
            }
            if (result == null) {
                throw new SnapshotException(MessageFormat.format("OQL Query does not yield a result: {0}", queryString));
            }
            throw new SnapshotException(MessageFormat.format("OQL query does not return a list of objects: {0}", queryString));
        }

        private int[] evalIncludeSubClassesAndInstances(int[] array) throws SnapshotException {
            int[] answer = array;
            if (this.hopa.includeSubclasses) {
                ArrayInt objIds = new ArrayInt();
                int[] nArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    IObject object = this.snapshot.getObject(id);
                    if (!(object instanceof IClass)) {
                        String msg = "Not a class: 0x{0} ({2}). If specifying ''{3}'', the selected objects all must be classes.";
                        throw new SnapshotException(MessageFormat.format(msg, Long.toHexString(object.getObjectAddress()), id, object.getClazz().getName(), "-include_class_instance"));
                    }
                    IClass clazz = (IClass)object;
                    if (this.hopa.includeClassInstance) {
                        objIds.add(clazz.getObjectId());
                    }
                    objIds.addAll(clazz.getObjectIds());
                    for (IClass subClazz : clazz.getAllSubclasses()) {
                        if (this.hopa.includeClassInstance) {
                            objIds.add(subClazz.getObjectId());
                        }
                        objIds.addAll(subClazz.getObjectIds());
                    }
                    ++n2;
                }
                answer = objIds.toArray();
            }
            return this.evalLoaderInstances(answer);
        }

        private int[] evalLoaderInstances(int[] answer) throws SnapshotException {
            if (!this.hopa.includeLoadedInstances) {
                return answer;
            }
            ArrayInt objIdxs = new ArrayInt();
            int ii = 0;
            while (ii < answer.length) {
                int objectId = answer[ii];
                IObject classLoader = this.snapshot.getObject(objectId);
                if (!(classLoader instanceof IClassLoader)) {
                    String msg = "Not a class loader: 0x{0} ({2}). If specifying ''{3}'', the selected objects all must be class loaders.";
                    throw new SnapshotException(MessageFormat.format(msg, Long.toHexString(classLoader.getObjectAddress()), objectId, classLoader.getClazz().getName(), "-include_loaded_instances"));
                }
                objIdxs.add(objectId);
                for (IClass clazz : this.snapshot.getClasses()) {
                    if (clazz.getClassLoaderId() != objectId) continue;
                    objIdxs.add(clazz.getObjectId());
                    int[] toAdd = clazz.getObjectIds();
                    objIdxs.addAll(toAdd);
                    if (!this.hopa.isVerbose) continue;
                    this.logger.log(Level.INFO, MessageFormat.format("Added class {0} and {1} instances of it", clazz.getName(), toAdd.length));
                }
                ++ii;
            }
            return objIdxs.toArray();
        }
    }
}

