/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.SimpleStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram
extends HistogramRecord
implements IResultTable,
IIconProvider {
    private static final long serialVersionUID = 2L;
    boolean isDefaultHistogram;
    private ArrayList<ClassHistogramRecord> classHistogramRecords;
    private ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords;

    Histogram() {
    }

    public Histogram(String label, ArrayList<ClassHistogramRecord> classHistogramRecords, ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        this(label, classHistogramRecords, classLoaderHistogramRecords, numberOfObjects, usedHeapSize, retainedHeapSize, false);
    }

    public Histogram(String label, ArrayList<ClassHistogramRecord> classHistogramRecords, ArrayList<ClassLoaderHistogramRecord> classLoaderHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize, boolean isDefaultHistogram) {
        super(label, numberOfObjects, usedHeapSize, retainedHeapSize);
        this.classHistogramRecords = classHistogramRecords;
        this.classLoaderHistogramRecords = classLoaderHistogramRecords;
        this.isDefaultHistogram = isDefaultHistogram;
    }

    public Collection<ClassHistogramRecord> getClassHistogramRecords() {
        return this.classHistogramRecords;
    }

    public Collection<ClassLoaderHistogramRecord> getClassLoaderHistogramRecords() {
        return this.classLoaderHistogramRecords;
    }

    public Histogram diffWithBaseline(Histogram baseline) {
        ClassHistogramRecord classDifference;
        String className;
        Map<String, ClassHistogramRecord> classDifferences;
        String classLoaderName;
        int classIdBase = -1000000000;
        int classLoaderIdBase = -2000000000;
        int classIdCurrent = classIdBase;
        int classLoaderIdCurrent = classLoaderIdBase;
        HashMap classLoaderDifferences = new HashMap();
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : this.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (HashMap<String, ClassHistogramRecord>)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap<String, ClassHistogramRecord>();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(classHistogramRecord.getUsedHeapSize());
            }
        }
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : baseline.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (Map)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(-classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(-classHistogramRecord.getUsedHeapSize());
            }
        }
        HashMap<String, ClassHistogramRecord> classDiffRecordsMerged = new HashMap<String, ClassHistogramRecord>();
        ArrayList<ClassLoaderHistogramRecord> classLoaderDiffRecordsMerged = new ArrayList<ClassLoaderHistogramRecord>();
        for (Map.Entry classDifferences2 : classLoaderDifferences.entrySet()) {
            ArrayList<ClassHistogramRecord> records = new ArrayList<ClassHistogramRecord>(((Map)classDifferences2.getValue()).values().size());
            int numberOfObjects = 0;
            long usedHeapSize = 0L;
            for (ClassHistogramRecord classDifference2 : ((Map)classDifferences2.getValue()).values()) {
                ClassHistogramRecord classDifferenceMerged = (ClassHistogramRecord)classDiffRecordsMerged.get(classDifference2.getLabel());
                if (classDifferenceMerged == null) {
                    classDifferenceMerged = new ClassHistogramRecord(classDifference2.getLabel(), --classIdCurrent, 0L, 0L, 0L);
                    classDiffRecordsMerged.put(classDifference2.getLabel(), classDifferenceMerged);
                }
                classDifferenceMerged.incNumberOfObjects(classDifference2.getNumberOfObjects());
                classDifferenceMerged.incUsedHeapSize(classDifference2.getUsedHeapSize());
                records.add(classDifference2);
                numberOfObjects = (int)((long)numberOfObjects + classDifference2.getNumberOfObjects());
                usedHeapSize += classDifference2.getUsedHeapSize();
            }
            classLoaderDiffRecordsMerged.add(new ClassLoaderHistogramRecord((String)classDifferences2.getKey(), --classLoaderIdCurrent, records, numberOfObjects, usedHeapSize, 0L));
        }
        return new Histogram("Histogram difference between " + this.getLabel() + " and " + baseline.getLabel(), new ArrayList<ClassHistogramRecord>(classDiffRecordsMerged.values()), classLoaderDiffRecordsMerged, Math.abs(this.getNumberOfObjects() - baseline.getNumberOfObjects()), Math.abs(this.getUsedHeapSize() - baseline.getUsedHeapSize()), Math.abs(this.getRetainedHeapSize() - baseline.getRetainedHeapSize()));
    }

    public Histogram intersectWithAnother(Histogram another) {
        ClassHistogramRecord classDifference;
        String className;
        Map<String, ClassHistogramRecord> classDifferences;
        String classLoaderName;
        int classIdBase = -1000000000;
        int classLoaderIdBase = -2000000000;
        int classIdCurrent = classIdBase;
        int classLoaderIdCurrent = classLoaderIdBase;
        HashMap classLoaderDifferences = new HashMap();
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : this.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (HashMap<String, ClassHistogramRecord>)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap<String, ClassHistogramRecord>();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = "Class$%" + classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get(className);
                if (classDifference == null) {
                    classDifference = new ClassHistogramRecord(className, --classIdCurrent, 0L, 0L, 0L);
                    classDifferences.put(className, classDifference);
                }
                classDifference.incNumberOfObjects(classHistogramRecord.getNumberOfObjects());
                classDifference.incUsedHeapSize(classHistogramRecord.getUsedHeapSize());
            }
        }
        for (ClassLoaderHistogramRecord classLoaderHistogramRecord : another.classLoaderHistogramRecords) {
            classLoaderName = classLoaderHistogramRecord.getLabel();
            classDifferences = (Map)classLoaderDifferences.get(classLoaderName);
            if (classDifferences == null) {
                classDifferences = new HashMap();
                classLoaderDifferences.put(classLoaderName, classDifferences);
            }
            for (ClassHistogramRecord classHistogramRecord : classLoaderHistogramRecord.getClassHistogramRecords()) {
                className = classHistogramRecord.getLabel();
                classDifference = (ClassHistogramRecord)classDifferences.get("Class$%" + className);
                if (classDifference == null || classDifference.getNumberOfObjects() <= 0L || classDifference.getNumberOfObjects() != classHistogramRecord.getNumberOfObjects()) continue;
                classDifferences.put(className, new ClassHistogramRecord(className, --classIdCurrent, classDifference.getNumberOfObjects(), classDifference.getUsedHeapSize() + classHistogramRecord.getUsedHeapSize(), 0L));
            }
        }
        HashMap<String, ClassHistogramRecord> classDiffRecordsMerged = new HashMap<String, ClassHistogramRecord>();
        ArrayList<ClassLoaderHistogramRecord> classLoaderDiffRecordsMerged = new ArrayList<ClassLoaderHistogramRecord>();
        int numberOfObjectsOverall = 0;
        long usedHeapSizeOverall = 0L;
        for (Map.Entry classDifferences2 : classLoaderDifferences.entrySet()) {
            ArrayList<ClassHistogramRecord> records = new ArrayList<ClassHistogramRecord>(((Map)classDifferences2.getValue()).values().size());
            int numberOfObjects = 0;
            long usedHeapSize = 0L;
            for (ClassHistogramRecord classDifference2 : ((Map)classDifferences2.getValue()).values()) {
                if (classDifference2.getLabel().startsWith("Class$%")) continue;
                ClassHistogramRecord classDifferenceMerged = (ClassHistogramRecord)classDiffRecordsMerged.get(classDifference2.getLabel());
                if (classDifferenceMerged == null) {
                    classDifferenceMerged = new ClassHistogramRecord(classDifference2.getLabel(), --classIdCurrent, 0L, 0L, 0L);
                    classDiffRecordsMerged.put(classDifference2.getLabel(), classDifferenceMerged);
                }
                classDifferenceMerged.incNumberOfObjects(classDifference2.getNumberOfObjects());
                classDifferenceMerged.incUsedHeapSize(classDifference2.getUsedHeapSize());
                records.add(classDifference2);
                numberOfObjects = (int)((long)numberOfObjects + classDifference2.getNumberOfObjects());
                numberOfObjectsOverall += numberOfObjects;
                usedHeapSizeOverall += (usedHeapSize += classDifference2.getUsedHeapSize());
            }
            if (records.size() <= 0) continue;
            classLoaderDiffRecordsMerged.add(new ClassLoaderHistogramRecord((String)classDifferences2.getKey(), --classLoaderIdCurrent, records, numberOfObjects, usedHeapSize, 0L));
        }
        return new Histogram("Histogram intersection of " + this.getLabel() + " and " + another.getLabel(), new ArrayList<ClassHistogramRecord>(classDiffRecordsMerged.values()), classLoaderDiffRecordsMerged, numberOfObjectsOverall, usedHeapSizeOverall, 0L);
    }

    public boolean isDefaultHistogram() {
        return this.isDefaultHistogram;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("Histogram ");
        buf.append(this.label);
        buf.append(" with ");
        buf.append(this.classLoaderHistogramRecords != null ? this.classLoaderHistogramRecords.size() : 0);
        buf.append(" class loaders, ");
        buf.append(this.classHistogramRecords != null ? this.classHistogramRecords.size() : 0);
        buf.append(" classes, ");
        buf.append(this.numberOfObjects);
        buf.append(" objects, ");
        buf.append(this.usedHeapSize);
        buf.append(" used heap bytes:");
        if (this.classHistogramRecords != null) {
            buf.append("\n\nCLASS STATISTICS:\n");
            buf.append(Histogram.alignRight("Objects", 17));
            buf.append(Histogram.alignRight("Shallow Heap", 17));
            buf.append(Histogram.alignRight("Retained Heap", 17));
            buf.append("  ");
            buf.append(Histogram.alignLeft("Class Name", 0));
            buf.append("\n");
            Histogram.appendRecords(buf, this.classHistogramRecords);
        }
        if (this.classLoaderHistogramRecords != null) {
            buf.append("\n\nCLASSLOADER STATISTICS:\n");
            buf.append(Histogram.alignRight("Objects", 17));
            buf.append(Histogram.alignRight("Shallow Heap", 17));
            buf.append(Histogram.alignRight("Retained Heap", 17));
            buf.append("  ");
            buf.append(Histogram.alignLeft("Class Name", 0));
            buf.append("\n");
            Histogram.appendRecords(buf, this.classLoaderHistogramRecords);
        }
        return buf.toString();
    }

    private static void appendRecords(StringBuilder summary, List<? extends HistogramRecord> records) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        for (HistogramRecord histogramRecord : records) {
            summary.append(Histogram.alignRight(formatter.format(histogramRecord.getNumberOfObjects()), 17));
            summary.append(Histogram.alignRight(formatter.format(histogramRecord.getUsedHeapSize()), 17));
            if (histogramRecord.getRetainedHeapSize() < 0L) {
                summary.append(Histogram.alignRight(">=" + formatter.format(-histogramRecord.getRetainedHeapSize()), 17));
            } else {
                summary.append(Histogram.alignRight(formatter.format(histogramRecord.getRetainedHeapSize()), 17));
            }
            summary.append("  ");
            summary.append(Histogram.alignLeft(histogramRecord.getLabel(), 0));
            summary.append("\n");
        }
    }

    private static String alignLeft(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        StringBuilder buf = new StringBuilder(length);
        int blanks = length - text.length();
        buf.append(text);
        int i = 0;
        while (i < blanks) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static String alignRight(String text, int length) {
        if (text.length() >= length) {
            return text;
        }
        StringBuilder buf = new StringBuilder(length);
        int blanks = length - text.length();
        int i = 0;
        while (i < blanks) {
            buf.append(' ');
            ++i;
        }
        buf.append(text);
        return buf.toString();
    }

    public static String generateClassHistogramRecordTextReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateHistogramRecordTextReport(new ArrayList<HistogramRecord>(histogram.getClassHistogramRecords()), comparator, new String[]{"Class Name", "Objects", "Heap", "Retained Heap"});
    }

    private static String generateHistogramRecordTextReport(List<HistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        Collections.sort(records, comparator);
        int labelLength = headers[0].length();
        int numberOfObjectsLength = headers[1].length();
        int usedHeapSizeLength = headers[2].length();
        int retainedHeapSizeLength = headers[3].length();
        for (HistogramRecord record : records) {
            if (record.getLabel().length() > labelLength) {
                labelLength = record.getLabel().length();
            }
            if (Long.toString(record.getNumberOfObjects()).length() > numberOfObjectsLength) {
                numberOfObjectsLength = Long.toString(record.getNumberOfObjects()).length();
            }
            if (Long.toString(record.getUsedHeapSize()).length() > usedHeapSizeLength) {
                usedHeapSizeLength = Long.toString(record.getUsedHeapSize()).length();
            }
            if (Long.toString(record.getRetainedHeapSize()).length() <= retainedHeapSizeLength) continue;
            retainedHeapSizeLength = Long.toString(record.getRetainedHeapSize()).length();
        }
        StringBuilder report = new StringBuilder((4 + records.size()) * (2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2 + 2));
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        report.append("| ");
        Histogram.appendStringAndFillUp(report, headers[0], ' ', labelLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[1], ' ', numberOfObjectsLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[2], ' ', usedHeapSizeLength);
        report.append(" | ");
        Histogram.appendStringAndFillUp(report, headers[3], ' ', retainedHeapSizeLength);
        report.append(" |\r\n");
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        for (HistogramRecord record : records) {
            report.append("| ");
            Histogram.appendStringAndFillUp(report, record.getLabel(), ' ', labelLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getNumberOfObjects()), ' ', numberOfObjectsLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getUsedHeapSize()), ' ', usedHeapSizeLength);
            report.append(" | ");
            Histogram.appendPreFillAndString(report, Long.toString(record.getRetainedHeapSize()), ' ', retainedHeapSizeLength);
            report.append(" |\r\n");
        }
        Histogram.appendStringAndFillUp(report, null, '-', 2 + labelLength + 3 + numberOfObjectsLength + 3 + usedHeapSizeLength + 3 + retainedHeapSizeLength + 2);
        report.append("\r\n");
        return report.toString();
    }

    public static String generateClassHistogramRecordCsvReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateHistogramRecordCsvReport(new ArrayList<ClassHistogramRecord>(histogram.getClassHistogramRecords()), comparator, new String[]{"Class Name", "Objects", "Shallow Heap", "Retained Heap"});
    }

    public static String generateClassLoaderHistogramRecordCsvReport(Histogram histogram, Comparator<HistogramRecord> comparator) {
        return Histogram.generateClassloaderHistogramCsvReport(new ArrayList<ClassLoaderHistogramRecord>(histogram.getClassLoaderHistogramRecords()), comparator, new String[]{"ClassLoader Name", "Class Name", "Objects", "Shallow Heap", "Retained Heap"});
    }

    private static String generateClassloaderHistogramCsvReport(List<ClassLoaderHistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        StringBuilder report = new StringBuilder((1 + records.size()) * 256);
        report.append(headers[0]);
        report.append(";");
        report.append(headers[1]);
        report.append(";");
        report.append(headers[2]);
        report.append(";");
        report.append(headers[3]);
        report.append(";");
        report.append(headers[4]);
        report.append(";\r\n");
        Collections.sort(records, comparator);
        for (ClassLoaderHistogramRecord classloaderRecord : records) {
            Collection<ClassHistogramRecord> classRecords = classloaderRecord.getClassHistogramRecords();
            ArrayList<ClassHistogramRecord> list = new ArrayList<ClassHistogramRecord>(classRecords);
            Collections.sort(list, COMPARATOR_FOR_USEDHEAPSIZE);
            int i = list.size() - 1;
            while (i >= 0) {
                ClassHistogramRecord record = (ClassHistogramRecord)list.get(i);
                report.append(classloaderRecord.getLabel());
                report.append(";");
                report.append(record.getLabel());
                report.append(";");
                report.append(record.getNumberOfObjects());
                report.append(";");
                report.append(record.getUsedHeapSize());
                report.append(";");
                if (record.getRetainedHeapSize() < 0L) {
                    report.append(">=" + -record.getRetainedHeapSize());
                } else {
                    report.append(record.getRetainedHeapSize());
                }
                report.append(";\r\n");
                --i;
            }
        }
        return report.toString();
    }

    private static String generateHistogramRecordCsvReport(List<ClassHistogramRecord> records, Comparator<HistogramRecord> comparator, String[] headers) {
        Collections.sort(records, comparator);
        StringBuilder report = new StringBuilder((1 + records.size()) * 256);
        report.append(headers[0]);
        report.append(";");
        report.append(headers[1]);
        report.append(";");
        report.append(headers[2]);
        report.append(";");
        report.append(headers[3]);
        report.append(";\r\n");
        for (HistogramRecord histogramRecord : records) {
            report.append(histogramRecord.getLabel());
            report.append(";");
            report.append(histogramRecord.getNumberOfObjects());
            report.append(";");
            report.append(histogramRecord.getUsedHeapSize());
            report.append(";");
            if (histogramRecord.getRetainedHeapSize() < 0L) {
                report.append(">=" + -histogramRecord.getRetainedHeapSize());
            } else {
                report.append(histogramRecord.getRetainedHeapSize());
            }
            report.append(";\r\n");
        }
        return report.toString();
    }

    private static void appendStringAndFillUp(StringBuilder report, String string, char character, int completeLength) {
        if (string != null) {
            report.append(string);
        }
        if (string != null) {
            completeLength -= string.length();
        }
        if (completeLength > 0) {
            int i = 0;
            while (i < completeLength) {
                report.append(character);
                ++i;
            }
        }
    }

    private static void appendPreFillAndString(StringBuilder report, String string, char character, int completeLength) {
        if (string != null) {
            completeLength -= string.length();
        }
        if (completeLength > 0) {
            int i = 0;
            while (i < completeLength) {
                report.append(character);
                ++i;
            }
        }
        if (string != null) {
            report.append(string);
        }
    }

    public ResultMetaData getResultMetaData() {
        return null;
    }

    public Column[] getColumns() {
        return new Column[]{new Column("Class Name", String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column("Objects", Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column("Shallow Heap", Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
    }

    public int getRowCount() {
        return this.classHistogramRecords.size();
    }

    public Object getRow(int rowId) {
        return this.classHistogramRecords.get(rowId);
    }

    public Object getColumnValue(Object row, int columnIndex) {
        ClassHistogramRecord record = (ClassHistogramRecord)row;
        switch (columnIndex) {
            case 0: {
                return record.getLabel();
            }
            case 1: {
                return record.getNumberOfObjects();
            }
            case 2: {
                return record.getUsedHeapSize();
            }
        }
        return null;
    }

    public IContextObject getContext(Object row) {
        final ClassHistogramRecord record = (ClassHistogramRecord)row;
        if (record.getClassId() < 0) {
            return null;
        }
        return new IContextObjectSet(){

            public int getObjectId() {
                return record.getClassId();
            }

            public int[] getObjectIds() {
                return record.getObjectIds();
            }

            public String getOQL() {
                return Histogram.this.isDefaultHistogram ? OQL.forObjectsOfClass(record.getClassId()) : null;
            }
        };
    }

    public URL getIcon(Object row) {
        return Icons.CLASS;
    }

    public IResultTree groupByClassLoader() {
        return new ClassLoaderTree(this);
    }

    public IResultTree groupByPackage() {
        return new PackageTree(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassLoaderTree
    implements IResultTree,
    IIconProvider {
        private Histogram histogram;

        public ClassLoaderTree(Histogram histogram) {
            this.histogram = histogram;
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column("Class Loader / Class", String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column("Objects", Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column("Shallow Heap", Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        }

        public List<?> getElements() {
            return this.histogram.classLoaderHistogramRecords;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ClassLoaderHistogramRecord;
        }

        public List<?> getChildren(Object parent) {
            return new ArrayList<ClassHistogramRecord>(((ClassLoaderHistogramRecord)parent).getClassHistogramRecords());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            HistogramRecord record = (HistogramRecord)row;
            switch (columnIndex) {
                case 0: {
                    return record.getLabel();
                }
                case 1: {
                    return record.getNumberOfObjects();
                }
                case 2: {
                    return record.getUsedHeapSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof ClassLoaderHistogramRecord) {
                final ClassLoaderHistogramRecord record = (ClassLoaderHistogramRecord)row;
                if (record.getClassLoaderId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassLoaderId();
                    }

                    public int[] getObjectIds() {
                        try {
                            return record.getObjectIds();
                        }
                        catch (SnapshotException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public String getOQL() {
                        if (((ClassLoaderTree)ClassLoaderTree.this).histogram.isDefaultHistogram) {
                            return OQL.classesByClassLoaderId(record.getClassLoaderId());
                        }
                        return null;
                    }
                };
            }
            if (row instanceof ClassHistogramRecord) {
                final ClassHistogramRecord record = (ClassHistogramRecord)row;
                if (record.getClassId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getObjectIds();
                    }

                    public String getOQL() {
                        if (((ClassLoaderTree)ClassLoaderTree.this).histogram.isDefaultHistogram) {
                            return OQL.forObjectsOfClass(record.getClassId());
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        public URL getIcon(Object row) {
            return row instanceof ClassLoaderHistogramRecord ? Icons.CLASSLOADER_INSTANCE : Icons.CLASS;
        }
    }

    private static class PackageNode
    extends HistogramRecord {
        private static final long serialVersionUID = 1L;
        Map<String, PackageNode> subPackages = new HashMap<String, PackageNode>();
        List<ClassHistogramRecord> classes = new ArrayList<ClassHistogramRecord>();

        public PackageNode(String name) {
            super(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PackageTree
    implements IResultTree,
    IIconProvider {
        private Histogram histogram;
        PackageNode root;

        public PackageTree(Histogram histogram) {
            this.histogram = histogram;
            this.buildTree(histogram);
        }

        private void buildTree(Histogram histogram) {
            this.root = new PackageNode("<ROOT>");
            for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
                PackageNode current = this.root;
                String[] path = SimpleStringTokenizer.split((String)record.getLabel(), (char)'.');
                int ii = 0;
                while (ii < path.length - 1) {
                    PackageNode child = current.subPackages.get(path[ii]);
                    if (child == null) {
                        child = new PackageNode(path[ii]);
                        current.subPackages.put(path[ii], child);
                    }
                    child.incNumberOfObjects(record.numberOfObjects);
                    child.incUsedHeapSize(record.getUsedHeapSize());
                    current = child;
                    ++ii;
                }
                current.classes.add(record);
            }
        }

        public Histogram getHistogram() {
            return this.histogram;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column("Package / Class", String.class).comparing(HistogramRecord.COMPARATOR_FOR_LABEL), new Column("Objects", Long.TYPE).comparing(HistogramRecord.COMPARATOR_FOR_NUMBEROFOBJECTS), new Column("Shallow Heap", Long.TYPE).sorting(Column.SortDirection.DESC).comparing(HistogramRecord.COMPARATOR_FOR_USEDHEAPSIZE)};
        }

        public List<?> getElements() {
            return this.getChildren(this.root);
        }

        public boolean hasChildren(Object element) {
            return element instanceof PackageNode;
        }

        public List<?> getChildren(Object parent) {
            PackageNode node = (PackageNode)parent;
            ArrayList<HistogramRecord> answer = new ArrayList<HistogramRecord>();
            answer.addAll(node.subPackages.values());
            answer.addAll(node.classes);
            return answer;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            HistogramRecord record = (HistogramRecord)row;
            switch (columnIndex) {
                case 0: {
                    return record.getLabel();
                }
                case 1: {
                    return record.getNumberOfObjects();
                }
                case 2: {
                    return record.getUsedHeapSize();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof PackageNode) {
                final PackageNode node = (PackageNode)row;
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return -1;
                    }

                    public int[] getObjectIds() {
                        ArrayInt objectIds = new ArrayInt();
                        LinkedList<PackageNode> nodes = new LinkedList<PackageNode>();
                        nodes.add(node);
                        while (!nodes.isEmpty()) {
                            PackageNode n = (PackageNode)nodes.removeFirst();
                            for (ClassHistogramRecord record : n.classes) {
                                objectIds.addAll(record.getObjectIds());
                            }
                            nodes.addAll(n.subPackages.values());
                        }
                        return objectIds.toArray();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            if (row instanceof ClassHistogramRecord) {
                final ClassHistogramRecord record = (ClassHistogramRecord)row;
                if (record.getClassId() < 0) {
                    return null;
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return record.getClassId();
                    }

                    public int[] getObjectIds() {
                        return record.getObjectIds();
                    }

                    public String getOQL() {
                        if (((PackageTree)PackageTree.this).histogram.isDefaultHistogram) {
                            return OQL.forObjectsOfClass(record.getClassId());
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        public URL getIcon(Object row) {
            return row instanceof PackageNode ? Icons.PACKAGE : Icons.CLASS;
        }
    }
}

