/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.mat.snapshot.model.IClass;

public final class OQL {
    private static final String OQL_classesByClassLoaderId = "select * from java.lang.Class c where c implements " + IClass.class.getName() + " and c.@classLoaderId = {0, number, 0}";

    public static final String forAddress(long address) {
        return "SELECT * FROM OBJECTS 0x" + Long.toHexString(address);
    }

    public static final String forObjectId(int objectId) {
        return "SELECT * FROM OBJECTS " + objectId;
    }

    public static String forObjectIds(int[] objectIds) {
        StringBuilder buf = new StringBuilder(512);
        buf.append("SELECT * FROM OBJECTS ");
        int ii = 0;
        while (ii < objectIds.length) {
            if (ii > 0) {
                buf.append(",");
            }
            buf.append(objectIds[ii]);
            ++ii;
        }
        return buf.toString();
    }

    public static final String retainedBy(String oqlQuery) {
        return "SELECT AS RETAINED SET * FROM OBJECTS (" + oqlQuery + ")";
    }

    public static String retainedBy(int objectId) {
        return "SELECT AS RETAINED SET * FROM OBJECTS " + objectId;
    }

    public static final String forObjectsOfClass(IClass clasz) {
        return "SELECT * FROM " + clasz.getName();
    }

    public static final String forObjectsOfClass(int classId) {
        return "SELECT * FROM " + classId;
    }

    public static void union(StringBuilder query, String other) {
        if (query.length() > 0) {
            query.append(" UNION (").append(other).append(")");
        } else {
            query.append(other);
        }
    }

    public static String instancesByPattern(Pattern pattern, boolean includeSubclasses) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT * FROM \"");
        if (includeSubclasses) {
            buf.append(" INSTANCEOF");
        }
        buf.append(pattern.pattern());
        buf.append("\"");
        return buf.toString();
    }

    public static String classesByPattern(Pattern pattern, boolean includeSubclasses) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SELECT * FROM OBJECTS \"");
        if (includeSubclasses) {
            buf.append(" INSTANCEOF");
        }
        buf.append(pattern.pattern());
        buf.append("\"");
        return buf.toString();
    }

    public static String instancesByClassLoaderId(int classLoaderId) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("select * from (");
        buf.append(OQL.classesByClassLoaderId(classLoaderId));
        buf.append(")");
        return buf.toString();
    }

    public static String classesByClassLoaderId(int classLoaderId) {
        return MessageFormat.format(OQL_classesByClassLoaderId, classLoaderId);
    }

    private OQL() {
    }
}

