/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.model;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public final class PrettyPrinter {
    public static String objectAsString(IObject stringObject, int limit) throws SnapshotException {
        Integer count = (Integer)stringObject.resolveValue("count");
        if (count == null) {
            return null;
        }
        if (count == 0) {
            return "";
        }
        IPrimitiveArray charArray = (IPrimitiveArray)stringObject.resolveValue("value");
        if (charArray == null) {
            return null;
        }
        Integer offset = (Integer)stringObject.resolveValue("offset");
        if (offset == null) {
            return null;
        }
        return PrettyPrinter.arrayAsString(charArray, offset, count, limit);
    }

    public static String arrayAsString(IPrimitiveArray charArray, int offset, int count, int limit) {
        char[] value;
        int contentToRead;
        if (charArray.getType() != 5) {
            return null;
        }
        int length = charArray.getLength();
        int n = contentToRead = count <= limit ? count : limit;
        if (contentToRead > length - offset) {
            contentToRead = length - offset;
        }
        if ((value = offset == 0 && length == contentToRead ? (char[])charArray.getValueArray() : (char[])charArray.getValueArray(offset, contentToRead)) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(value.length);
        int ii = 0;
        while (ii < value.length) {
            char val = value[ii];
            if (val >= ' ' && val < '\u007f') {
                result.append(val);
            } else {
                result.append("\\u").append(String.format("%04x", 0xFFFF & val));
            }
            ++ii;
        }
        if (limit < count) {
            result.append("...");
        }
        return result.toString();
    }

    private PrettyPrinter() {
    }
}

