/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapObjectLong;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public class RetainedSizeDerivedData
extends ContextDerivedData {
    public static final ContextDerivedData.DerivedOperation APPROXIMATE = new ContextDerivedData.DerivedOperation("APPROXIMATE", "Calculate Minimum Retained Size (quick approx.)");
    public static final ContextDerivedData.DerivedOperation PRECISE = new ContextDerivedData.DerivedOperation("PRECISE", "Calculate Precise Retained Size");
    private static final ContextDerivedData.DerivedColumn COLUMN = new ContextDerivedData.DerivedColumn("Retained Heap", new ContextDerivedData.DerivedOperation[]{APPROXIMATE, PRECISE});
    private ISnapshot snapshot;

    public RetainedSizeDerivedData(ISnapshot snaphot) {
        this.snapshot = snaphot;
    }

    public ContextDerivedData.DerivedColumn[] getDerivedColumns() {
        return new ContextDerivedData.DerivedColumn[]{COLUMN};
    }

    public String labelFor(ContextDerivedData.DerivedColumn derivedColumn, ContextProvider provider) {
        return provider.getLabel() == null ? derivedColumn.getLabel() : String.valueOf(derivedColumn.getLabel()) + " - " + provider.getLabel();
    }

    public Column columnFor(ContextDerivedData.DerivedColumn derivedColumn, IResult result, ContextProvider provider) {
        if (derivedColumn != COLUMN) {
            throw new IllegalArgumentException();
        }
        String label = this.labelFor(derivedColumn, provider);
        DerivedCalculatorImpl calculator = null;
        calculator = result instanceof Histogram ? new AllClasses(this.snapshot, provider, result) : (result instanceof Histogram.ClassLoaderTree ? new AllClasses(this.snapshot, provider, result) : (result instanceof Histogram.PackageTree ? new AllClasses(this.snapshot, provider, result) : new DerivedCalculatorImpl(this.snapshot, provider)));
        Column column = new Column(label, Long.TYPE).comparing((Comparator)new RetainedSizeComparator(calculator)).formatting((Format)new RetainedSizeFormat()).noTotals();
        column.setData(Filter.ValueConverter.class, (Object)new Filter.ValueConverter(){

            public double convert(double source) {
                return Math.abs(source);
            }
        });
        column.setData(ContextDerivedData.DerivedCalculator.class, (Object)calculator);
        column.setData(ContextDerivedData.DerivedColumn.class, (Object)derivedColumn);
        return column;
    }

    private static class AllClasses
    extends DerivedCalculatorImpl {
        public AllClasses(ISnapshot snaphot, ContextProvider provider, IResult result) {
            super(snaphot, provider);
            if (result instanceof Histogram) {
                try {
                    VoidProgressListener listener = new VoidProgressListener();
                    Histogram histogram = (Histogram)result;
                    for (ClassHistogramRecord r : histogram.getClassHistogramRecords()) {
                        r.calculateRetainedSize(snaphot, false, true, (IProgressListener)listener);
                    }
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            if (result instanceof Histogram.ClassLoaderTree) {
                try {
                    VoidProgressListener listener = new VoidProgressListener();
                    Histogram.ClassLoaderTree classLoaderTree = (Histogram.ClassLoaderTree)result;
                    for (Object element : classLoaderTree.getElements()) {
                        ((ClassLoaderHistogramRecord)element).calculateRetainedSize(this.snapshot, false, true, (IProgressListener)listener);
                    }
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            if (result instanceof Histogram.PackageTree) {
                try {
                    VoidProgressListener listener = new VoidProgressListener();
                    Histogram.PackageTree packageTree = (Histogram.PackageTree)result;
                    LinkedList nodes = new LinkedList();
                    nodes.addAll(packageTree.getElements());
                    while (!nodes.isEmpty()) {
                        Object child = nodes.removeFirst();
                        if (packageTree.hasChildren(child)) {
                            nodes.addAll(packageTree.getChildren(child));
                        }
                        if (!(child instanceof ClassHistogramRecord)) continue;
                        ((ClassHistogramRecord)child).calculateRetainedSize(snaphot, false, true, (IProgressListener)listener);
                    }
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public Object lookup(Object row) {
            if (row instanceof ClassHistogramRecord) {
                long size = ((ClassHistogramRecord)row).getRetainedHeapSize();
                return size != 0L ? Long.valueOf(size) : null;
            }
            if (row instanceof ClassLoaderHistogramRecord) {
                long size = ((ClassLoaderHistogramRecord)row).getRetainedHeapSize();
                return size != 0L ? Long.valueOf(size) : null;
            }
            return super.lookup(row);
        }

        public void calculate(ContextDerivedData.DerivedOperation operation, Object row, IProgressListener listener) throws SnapshotException {
            if (row instanceof ClassHistogramRecord) {
                ((ClassHistogramRecord)row).calculateRetainedSize(this.snapshot, true, operation == APPROXIMATE, listener);
            } else if (row instanceof ClassLoaderHistogramRecord) {
                ((ClassLoaderHistogramRecord)row).calculateRetainedSize(this.snapshot, true, operation == APPROXIMATE, listener);
            } else {
                super.calculate(operation, row, listener);
            }
        }
    }

    private static class DerivedCalculatorImpl
    implements ContextDerivedData.DerivedCalculator {
        protected final ISnapshot snapshot;
        protected final ContextProvider provider;
        protected final HashMapObjectLong<Object> values;

        DerivedCalculatorImpl(ISnapshot snaphot, ContextProvider provider) {
            this.snapshot = snaphot;
            this.provider = provider;
            this.values = new HashMapObjectLong();
        }

        public Object lookup(Object row) {
            try {
                return this.values.get(row);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }

        public void calculate(ContextDerivedData.DerivedOperation operation, Object row, IProgressListener listener) throws SnapshotException {
            IContextObject contextObject = this.provider.getContext(row);
            if (contextObject == null) {
                return;
            }
            try {
                long v = this.values.get(row);
                if (v > 0L || operation == APPROXIMATE) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            if (contextObject instanceof IContextObjectSet) {
                int[] retainedSet = ((IContextObjectSet)contextObject).getObjectIds();
                if (retainedSet != null) {
                    if (retainedSet.length == 1 && retainedSet[0] == -1) {
                        String msg = "Context provider ''{0}'' returned an illegal context object set for ''{1}}'' with content ''{{2}}'''. Return null instead.";
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(msg, this.provider.getClass().getName(), row.getClass().getName(), row.toString()));
                        return;
                    }
                    long retainedSize = 0L;
                    if (retainedSet.length == 1) {
                        retainedSize = this.snapshot.getRetainedHeapSize(retainedSet[0]);
                    } else if (operation == APPROXIMATE) {
                        retainedSize = this.snapshot.getMinRetainedSize(retainedSet, listener);
                        retainedSize = -retainedSize;
                    } else {
                        retainedSet = this.snapshot.getRetainedSet(retainedSet, listener);
                        retainedSize = this.snapshot.getHeapSize(retainedSet);
                    }
                    this.values.put(row, retainedSize);
                }
            } else {
                int objectId = contextObject.getObjectId();
                if (objectId < 0) {
                    String msg = "Context provider ''{0}'' returned an context object with an illegeal object id for ''{1}}''. Return null instead.";
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(msg, this.provider.getClass().getName(), row.toString()));
                } else {
                    long retainedSize = this.snapshot.getRetainedHeapSize(contextObject.getObjectId());
                    this.values.put(row, retainedSize);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RetainedSizeComparator
    implements Comparator<Object> {
        private ContextDerivedData.DerivedCalculator calculator;

        public RetainedSizeComparator(ContextDerivedData.DerivedCalculator calculator) {
            this.calculator = calculator;
        }

        @Override
        public int compare(Object o1, Object o2) {
            long diff;
            Long retainedSize_o1 = (Long)this.calculator.lookup(o1);
            Long retainedSize_o2 = (Long)this.calculator.lookup(o2);
            if (retainedSize_o1 == null) {
                return retainedSize_o2 == null ? 0 : -1;
            }
            if (retainedSize_o2 == null) {
                return 1;
            }
            long retained_o1 = retainedSize_o1;
            long retained_o2 = retainedSize_o2;
            if (retained_o1 < 0L) {
                retained_o1 = -retained_o1;
            }
            if (retained_o2 < 0L) {
                retained_o2 = -retained_o2;
            }
            return (diff = retained_o1 - retained_o2) == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    }

    private static final class RetainedSizeFormat
    extends Format {
        private static final long serialVersionUID = 1L;
        private static final Format formatter = new DecimalFormat("#,##0");

        private RetainedSizeFormat() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            Long v = (Long)obj;
            if (v < 0L) {
                toAppendTo.append(">= ");
                formatter.format(-v.longValue(), toAppendTo, pos);
            } else {
                formatter.format(v, toAppendTo, pos);
            }
            return toAppendTo;
        }

        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

