/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.text.MessageFormat;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.snapshot.HeapObjectArgumentFactory;
import org.eclipse.mat.internal.snapshot.SnapshotQueryContext;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;

public class SnapshotQuery {
    private final ISnapshot snapshot;
    private final QueryDescriptor query;
    private final ArgumentSet arguments;

    public static SnapshotQuery lookup(String name, ISnapshot snapshot) throws SnapshotException {
        QueryDescriptor query = QueryRegistry.instance().getQuery(name);
        if (query == null) {
            throw new SnapshotException(MessageFormat.format("Query not available: {0}", name));
        }
        SnapshotQueryContext context = new SnapshotQueryContext(snapshot);
        if (!query.accept((IQueryContext)context)) {
            throw new SnapshotException(query.explain((IQueryContext)context));
        }
        ArgumentSet arguments = query.createNewArgumentSet((IQueryContext)context);
        return new SnapshotQuery(snapshot, arguments);
    }

    public static SnapshotQuery parse(String commandLine, ISnapshot snapshot) throws SnapshotException {
        SnapshotQueryContext context = new SnapshotQueryContext(snapshot);
        ArgumentSet arguments = CommandLine.parse((IQueryContext)context, (String)commandLine);
        return new SnapshotQuery(snapshot, arguments);
    }

    private SnapshotQuery(ISnapshot snapshot, ArgumentSet arguments) {
        this.snapshot = snapshot;
        this.query = arguments.getQueryDescriptor();
        this.arguments = arguments;
    }

    public SnapshotQuery set(String name, Object value) throws SnapshotException {
        ArgumentDescriptor argument = this.query.getArgumentByName(name);
        if (argument == null) {
            throw new SnapshotException(MessageFormat.format("Unknown argument: {0} for query {1}", name, this.query.getIdentifier()));
        }
        if (argument.getType() == Integer.TYPE && argument.getAdvice() == Argument.Advice.HEAP_OBJECT || argument.getType().isAssignableFrom(IObject.class) || argument.getType().isAssignableFrom(IHeapObjectArgument.class)) {
            boolean cfr_ignored_0 = value instanceof ArgumentFactory;
            if (value instanceof IObject) {
                value = HeapObjectArgumentFactory.build(this.snapshot, new int[]{((IObject)value).getObjectId()});
            } else if (value instanceof Integer) {
                value = HeapObjectArgumentFactory.build(this.snapshot, new int[]{(Integer)value});
            } else if (value instanceof int[]) {
                value = HeapObjectArgumentFactory.build(this.snapshot, (int[])value);
            } else if (value instanceof ArrayInt) {
                value = HeapObjectArgumentFactory.build(this.snapshot, ((ArrayInt)value).toArray());
            } else if (value instanceof IHeapObjectArgument) {
                value = HeapObjectArgumentFactory.build(this.snapshot, (IHeapObjectArgument)value);
            } else {
                throw new SnapshotException(MessageFormat.format("Unsupported type for argument {0}: {1}\n(Use: IObject, Integer, int[], ArrayInt, IHeapObjectArgument)", name, value.getClass().getName()));
            }
        }
        this.arguments.setArgumentValue(argument, value);
        return this;
    }

    public IResult execute(IProgressListener listener) throws SnapshotException {
        QueryResult result = this.arguments.execute(listener);
        return result != null ? result.getSubject() : null;
    }

    public RefinedResultBuilder refine(IProgressListener listener) throws SnapshotException {
        IResult result = this.execute(listener);
        if (result == null) {
            throw new SnapshotException(MessageFormat.format("Query {0} did not produce a result.", this.arguments.getQueryDescriptor().getIdentifier()));
        }
        return new RefinedResultBuilder((IQueryContext)new SnapshotQueryContext(this.snapshot), (IStructuredResult)result);
    }
}

