/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.snapshot.ObjectMarker;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GarbageCleaner {
    GarbageCleaner() {
    }

    public static int[] clean(final PreliminaryIndexImpl idx, SnapshotImplBuilder builder, IProgressListener listener) throws IOException {
        IndexManager idxManager = new IndexManager();
        try {
            listener.beginTask("Removing unreachable objects", 11);
            listener.subTask("Searching for unreachable objects");
            int oldNoOfObjects = idx.identifiers.size();
            boolean[] reachable = new boolean[oldNoOfObjects];
            int newNoOfObjects = 0;
            int[] newRoots = idx.gcRoots.getAllKeys();
            IIndexReader.IOne2LongIndex identifiers = idx.identifiers;
            IIndexReader.IOne2ManyIndex preOutbound = idx.outbound;
            IIndexReader.IOne2OneIndex object2classId = idx.object2classId;
            HashMapIntObject<ClassImpl> classesById = idx.classesById;
            int numProcessors = Runtime.getRuntime().availableProcessors();
            ObjectMarker marker = new ObjectMarker(newRoots, reachable, preOutbound, (IProgressListener)new VoidProgressListener());
            if (numProcessors > 1) {
                try {
                    marker.markMultiThreaded(numProcessors);
                }
                catch (InterruptedException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                boolean[] blArray = reachable;
                int n = reachable.length;
                int ioe = 0;
                while (ioe < n) {
                    boolean b = blArray[ioe];
                    if (b) {
                        ++newNoOfObjects;
                    }
                    ++ioe;
                }
            } else {
                try {
                    newNoOfObjects = marker.markSingleThreaded();
                }
                catch (IProgressListener.OperationCanceledException operationCanceledException) {
                    idx.delete();
                    if (idxManager != null && listener.isCanceled()) {
                        idxManager.delete();
                    }
                    return null;
                }
            }
            marker = null;
            if (ParserPlugin.getDefault().isDebugging()) {
                GarbageCleaner.printHistogramOfUnreachableObjects(idx, reachable);
            }
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask("Re-indexing objects");
            final int[] map = new int[oldNoOfObjects];
            long[] id2a = new long[newNoOfObjects];
            ArrayList<ClassImpl> classes2remove = new ArrayList<ClassImpl>();
            IIndexReader.IOne2OneIndex preA2size = idx.array2size;
            int ii = 0;
            int jj = 0;
            while (ii < oldNoOfObjects) {
                if (reachable[ii]) {
                    map[ii] = jj;
                    id2a[jj++] = identifiers.get(ii);
                } else {
                    map[ii] = -1;
                    int classId = object2classId.get(ii);
                    ClassImpl clazz = (ClassImpl)classesById.get(classId);
                    if (clazz.isArrayType()) {
                        clazz.removeInstance(preA2size.get(ii));
                    } else {
                        ClassImpl c = (ClassImpl)classesById.get(ii);
                        if (c == null) {
                            clazz.removeInstance(clazz.getHeapSizePerInstance());
                        } else {
                            clazz.removeInstance(c.getUsedHeapSize());
                            classes2remove.add(c);
                        }
                    }
                }
                ++ii;
            }
            for (ClassImpl c : classes2remove) {
                classesById.remove(c.getObjectId());
                ClassImpl superclass = (ClassImpl)classesById.get(c.getSuperClassId());
                if (superclass == null) continue;
                superclass.removeSubClass(c);
            }
            reachable = null;
            identifiers.close();
            identifiers.delete();
            identifiers = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask("Re-indexing classes");
            HashMapIntObject classesByNewId = new HashMapIntObject(classesById.size());
            Iterator iter = classesById.values();
            while (iter.hasNext()) {
                ClassImpl clazz = (ClassImpl)iter.next();
                int index = map[clazz.getObjectId()];
                clazz.setObjectId(index);
                if (clazz.getSuperClassId() >= 0) {
                    clazz.setSuperClassIndex(map[clazz.getSuperClassId()]);
                }
                clazz.setClassLoaderIndex(map[clazz.getClassLoaderId()]);
                classesByNewId.put(index, (Object)clazz);
            }
            idx.getSnapshotInfo().setNumberOfClasses(classesByNewId.size());
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            File indexFile = IndexManager.Index.IDENTIFIER.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageFormat.format("Writing {0}", indexFile.getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.IDENTIFIER, new IndexWriter.LongIndexStreamer().writeTo(indexFile, id2a));
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.O2CLASS.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageFormat.format("Writing {0}", indexFile.getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.O2CLASS, new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(){

                int doGetNextInt(int index) {
                    return map[idx.object2classId.get(this.nextIndex)];
                }

                int[] getMap() {
                    return map;
                }
            }));
            object2classId.close();
            object2classId.delete();
            object2classId = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            indexFile = IndexManager.Index.A2SIZE.getFile(idx.snapshotInfo.getPrefix());
            listener.subTask(MessageFormat.format("Writing {0}", indexFile.getAbsolutePath()));
            final BitField arrayObjects = new BitField(newNoOfObjects);
            idxManager.setReader(IndexManager.Index.A2SIZE, new IndexWriter.IntIndexStreamer().writeTo(indexFile, new NewObjectIntIterator(preA2size){
                IIndexReader.IOne2OneIndex a2size;
                int newIndex;
                {
                    this.a2size = iOne2OneIndex;
                    this.newIndex = 0;
                }

                int doGetNextInt(int index) {
                    int size = this.a2size.get(this.nextIndex);
                    if (size > 0) {
                        arrayObjects.set(this.newIndex);
                    }
                    ++this.newIndex;
                    return size;
                }

                int[] getMap() {
                    return map;
                }
            }));
            preA2size.close();
            preA2size.delete();
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask("Re-indexing outbound index");
            IndexWriter.IntArray1NSortedWriter w_out = new IndexWriter.IntArray1NSortedWriter(newNoOfObjects, IndexManager.Index.OUTBOUND.getFile(idx.snapshotInfo.getPrefix()));
            IndexWriter.InboundWriter w_in = new IndexWriter.InboundWriter(newNoOfObjects, IndexManager.Index.INBOUND.getFile(idx.snapshotInfo.getPrefix()));
            int ii2 = 0;
            while (ii2 < oldNoOfObjects) {
                int k = map[ii2];
                if (k >= 0) {
                    int[] a = preOutbound.get(ii2);
                    ArrayInt tl = new ArrayInt(a.length);
                    int jj2 = 0;
                    while (jj2 < a.length) {
                        int t = map[a[jj2]];
                        if (t >= 0) {
                            tl.add(t);
                            w_in.log(t, k, jj2 == 0);
                        }
                        ++jj2;
                    }
                    w_out.log(k, tl.toArray());
                }
                ++ii2;
            }
            preOutbound.close();
            preOutbound.delete();
            preOutbound = null;
            if (listener.isCanceled()) {
                w_in.cancel();
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageFormat.format("Writing {0}", w_in.getIndexFile().getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.INBOUND, w_in.flush(listener, new KeyWriterImpl((HashMapIntObject<ClassImpl>)classesByNewId)));
            w_in = null;
            if (listener.isCanceled()) {
                w_out.cancel();
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            listener.subTask(MessageFormat.format("Writing {0}", w_out.getIndexFile().getAbsolutePath()));
            idxManager.setReader(IndexManager.Index.OUTBOUND, w_out.flush());
            w_out = null;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            listener.worked(1);
            HashMapIntObject<XGCRootInfo[]> roots = GarbageCleaner.fix(idx.gcRoots, map);
            idx.getSnapshotInfo().setNumberOfGCRoots(roots.size());
            HashMapIntObject rootsPerThread = new HashMapIntObject();
            IteratorInt iter2 = idx.thread2objects2roots.keys();
            while (iter2.hasNext()) {
                int threadId = iter2.next();
                int fixedThreadId = map[threadId];
                if (fixedThreadId < 0) continue;
                rootsPerThread.put(fixedThreadId, GarbageCleaner.fix((HashMapIntObject<List<XGCRootInfo>>)((HashMapIntObject)idx.thread2objects2roots.get(threadId)), map));
            }
            builder.setIndexManager(idxManager);
            builder.setClassCache((HashMapIntObject<ClassImpl>)classesByNewId);
            builder.setArrayObjects(arrayObjects);
            builder.setRoots(roots);
            builder.setRootsPerThread((HashMapIntObject<HashMapIntObject<XGCRootInfo[]>>)rootsPerThread);
            int[] nArray = map;
            return nArray;
        }
        finally {
            idx.delete();
            if (idxManager != null && listener.isCanceled()) {
                idxManager.delete();
            }
        }
    }

    private static HashMapIntObject<XGCRootInfo[]> fix(HashMapIntObject<List<XGCRootInfo>> roots, int[] map) {
        HashMapIntObject answer = new HashMapIntObject(roots.size());
        Iterator iter = roots.values();
        while (iter.hasNext()) {
            List r = (List)iter.next();
            XGCRootInfo[] a = new XGCRootInfo[r.size()];
            int ii = 0;
            while (ii < a.length) {
                a[ii] = (XGCRootInfo)((Object)r.get(ii));
                a[ii].setObjectId(map[a[ii].getObjectId()]);
                if (a[ii].getContextAddress() != 0L) {
                    a[ii].setContextId(map[a[ii].getContextId()]);
                }
                ++ii;
            }
            answer.put(a[0].getObjectId(), (Object)a);
        }
        return answer;
    }

    private static void printHistogramOfUnreachableObjects(PreliminaryIndexImpl idx, boolean[] reachable) {
        IIndexReader.IOne2OneIndex array2size = idx.array2size;
        HashMapIntObject histogram = new HashMapIntObject();
        int totalObjectCount = 0;
        long totalSize = 0L;
        int ii = 0;
        while (ii < reachable.length) {
            if (!reachable[ii]) {
                int s;
                int classId = idx.object2classId.get(ii);
                Record r = (Record)histogram.get(classId);
                if (r == null) {
                    ClassImpl clazz = (ClassImpl)idx.classesById.get(classId);
                    r = new Record(clazz);
                    histogram.put(classId, (Object)r);
                }
                ++r.objectCount;
                ++totalObjectCount;
                if (r.clazz.isArrayType()) {
                    s = array2size.get(ii);
                    r.size += (long)s;
                    totalSize += (long)s;
                } else {
                    s = r.clazz.getHeapSizePerInstance();
                    r.size += (long)s;
                    totalSize += (long)s;
                }
            }
            ++ii;
        }
        ArrayList<Record> records = new ArrayList<Record>();
        Iterator iter = histogram.values();
        while (iter.hasNext()) {
            records.add((Record)iter.next());
        }
        Collections.sort(records);
        System.out.println(String.format("%-58s %10s %10s", "Class", "Count", "Size"));
        for (Record record : records) {
            System.out.println(String.format("%-58s %10d %10d", record.clazz.getName(), record.objectCount, record.size));
        }
        System.out.println(String.format("%-58s %10d %10d", "Totals", totalObjectCount, totalSize));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyWriterImpl
    implements IndexWriter.KeyWriter {
        HashMapIntObject<ClassImpl> classesByNewId;

        KeyWriterImpl(HashMapIntObject<ClassImpl> classesByNewId) {
            this.classesByNewId = classesByNewId;
        }

        @Override
        public void storeKey(int index, Serializable key) {
            ClassImpl impl = (ClassImpl)this.classesByNewId.get(index);
            impl.setCacheEntry(key);
        }
    }

    private static abstract class NewObjectIntIterator
    extends NewObjectIterator
    implements IteratorInt {
        private NewObjectIntIterator() {
        }

        public int next() {
            int answer = this.doGetNextInt(this.nextIndex);
            this.findNext();
            return answer;
        }

        abstract int doGetNextInt(int var1);
    }

    private static abstract class NewObjectIterator {
        int nextIndex = -1;
        int[] $map = this.getMap();

        public NewObjectIterator() {
            this.findNext();
        }

        protected void findNext() {
            ++this.nextIndex;
            while (this.nextIndex < this.$map.length && this.$map[this.nextIndex] < 0) {
                ++this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.$map.length;
        }

        abstract int[] getMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Record
    implements Comparable<Record> {
        ClassImpl clazz;
        int objectCount;
        long size;

        public Record(ClassImpl clazz) {
            this.clazz = clazz;
        }

        @Override
        public int compareTo(Record o) {
            if (this.size > o.size) {
                return -1;
            }
            if (this.size < o.size) {
                return 1;
            }
            if (this.objectCount > o.objectCount) {
                return -1;
            }
            if (this.objectCount < o.objectCount) {
                return 1;
            }
            return this.clazz.getName().compareTo(o.clazz.getName());
        }
    }
}

