/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.internal.GarbageCleaner;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.oql.OQLQueryImpl;
import org.eclipse.mat.parser.internal.util.ParserRegistry;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotFactoryImpl
implements SnapshotFactory.Implementation {
    private Map<File, SnapshotEntry> snapshotCache = new HashMap<File, SnapshotEntry>();

    public ISnapshot openSnapshot(File file, IProgressListener listener) throws SnapshotException {
        ISnapshot answer = null;
        SnapshotEntry entry = this.snapshotCache.get(file);
        if (entry != null && (answer = (ISnapshot)entry.snapshot.get()) != null) {
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount + 1;
            return answer;
        }
        String name = file.getAbsolutePath();
        int p = name.lastIndexOf(46);
        String prefix = p >= 0 ? name.substring(0, p + 1) : name;
        try {
            File indexFile = new File(String.valueOf(prefix) + "index");
            if (indexFile.exists() && file.lastModified() < indexFile.lastModified()) {
                answer = SnapshotImpl.readFromFile(file, prefix, listener);
            }
        }
        catch (IOException ignore_and_reparse) {
            String text = ignore_and_reparse.getMessage() != null ? ignore_and_reparse.getMessage() : ignore_and_reparse.getClass().getName();
            String message = MessageFormat.format("Reparsing heap dump file due to {0}", text);
            listener.sendUserMessage(IProgressListener.Severity.WARNING, message, (Throwable)ignore_and_reparse);
        }
        if (answer == null) {
            this.deleteIndexFiles(file);
            answer = this.parse(file, prefix, listener);
        }
        entry = new SnapshotEntry(1, answer);
        this.snapshotCache.put(file, entry);
        return answer;
    }

    public synchronized void dispose(ISnapshot snapshot) {
        Iterator<SnapshotEntry> iter = this.snapshotCache.values().iterator();
        while (iter.hasNext()) {
            SnapshotEntry entry = iter.next();
            ISnapshot s = (ISnapshot)entry.snapshot.get();
            if (s == null) {
                iter.remove();
                continue;
            }
            if (s != snapshot) continue;
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount - 1;
            if (entry.usageCount == 0) {
                snapshot.dispose();
                iter.remove();
            }
            return;
        }
        if (snapshot != null) {
            snapshot.dispose();
        }
    }

    public IOQLQuery createQuery(String queryString) throws SnapshotException {
        return new OQLQueryImpl(queryString);
    }

    public List<SnapshotFormat> getSupportedFormats() {
        ArrayList<SnapshotFormat> answer = new ArrayList<SnapshotFormat>(5);
        for (ParserRegistry.Parser parser : ParserPlugin.getDefault().getParserRegistry().delegates()) {
            answer.add(parser.getSnapshotFormat());
        }
        return answer;
    }

    private final ISnapshot parse(File file, String prefix, IProgressListener listener) throws SnapshotException {
        ParserRegistry registry = ParserPlugin.getDefault().getParserRegistry();
        List<ParserRegistry.Parser> parsers = registry.matchParser(file.getName());
        if (parsers.isEmpty()) {
            parsers.addAll(registry.delegates());
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (ParserRegistry.Parser parser : parsers) {
            IIndexBuilder indexBuilder = parser.create(IIndexBuilder.class, "indexBuilder");
            try {
                indexBuilder.init(file, prefix);
                XSnapshotInfo snapshotInfo = new XSnapshotInfo();
                snapshotInfo.setPath(file.getAbsolutePath());
                snapshotInfo.setPrefix(prefix);
                snapshotInfo.setProperty("$heapFormat", (Serializable)((Object)parser.getId()));
                PreliminaryIndexImpl idx = new PreliminaryIndexImpl(snapshotInfo);
                indexBuilder.fill(idx, listener);
                SnapshotImplBuilder builder = new SnapshotImplBuilder(idx.getSnapshotInfo());
                int[] purgedMapping = GarbageCleaner.clean(idx, builder, listener);
                indexBuilder.clean(purgedMapping, listener);
                SnapshotImpl snapshot = builder.create(parser, listener);
                snapshot.calculateDominatorTree(listener);
                return snapshot;
            }
            catch (IOException ioe) {
                errors.add(ioe);
                indexBuilder.cancel();
            }
            catch (Exception e) {
                indexBuilder.cancel();
                throw SnapshotException.rethrow((Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            MultiStatus status = new MultiStatus("org.eclipse.mat.parser", 0, "Error opening heap dump", null);
            for (IOException error : errors) {
                status.add((IStatus)new Status(4, "org.eclipse.mat.parser", 0, error.getMessage(), (Throwable)error));
            }
            ParserPlugin.getDefault().getLog().log((IStatus)status);
            throw new SnapshotException(MessageFormat.format("Error opening heap dump ''{0}''. Check log for details.", file.getName()));
        }
        throw new SnapshotException(MessageFormat.format("No parser registered for file ''{0}''", file.getName()));
    }

    private void deleteIndexFiles(File file) {
        Pattern logPattern;
        Pattern indexPattern;
        String filename;
        int p;
        String fragment;
        File[] files;
        File directory = file.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        if ((files = directory.listFiles(new FileFilter(fragment = (p = (filename = file.getName()).lastIndexOf(46)) >= 0 ? filename.substring(0, p) : filename, indexPattern = Pattern.compile("\\.(.*\\.)?index$"), logPattern = Pattern.compile("\\.inbound\\.index.*\\.log$")){
            private final /* synthetic */ String val$fragment;
            private final /* synthetic */ Pattern val$indexPattern;
            private final /* synthetic */ Pattern val$logPattern;
            {
                this.val$fragment = string;
                this.val$indexPattern = pattern;
                this.val$logPattern = pattern2;
            }

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = f.getName();
                return name.startsWith(this.val$fragment) && (this.val$indexPattern.matcher(name).matches() || this.val$logPattern.matcher(name).matches());
            }
        })) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
    }

    private static class SnapshotEntry {
        private int usageCount;
        private WeakReference<ISnapshot> snapshot;

        public SnapshotEntry(int usageCount, ISnapshot snapshot) {
            this.usageCount = usageCount;
            this.snapshot = new WeakReference<ISnapshot>(snapshot);
        }
    }
}

