/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.HistogramRecord;

public class ClassHistogramRecordBuilder
extends HistogramRecord {
    private static final long serialVersionUID = 1L;
    private int classId;
    private ArrayIntBig objectIds;

    public ClassHistogramRecordBuilder(String label, int classId) {
        super(label, 0L, 0L, 0L);
        this.classId = classId;
        this.objectIds = new ArrayIntBig();
    }

    public void add(long usedHeapSize) {
        ++this.numberOfObjects;
        this.usedHeapSize += usedHeapSize;
    }

    public void add(int objectId, long usedHeapSize) {
        this.objectIds.add(objectId);
        ++this.numberOfObjects;
        this.usedHeapSize += usedHeapSize;
    }

    public void addAll(long numberOfObjects, long usedHeapSize) {
        this.numberOfObjects += numberOfObjects;
        this.usedHeapSize += usedHeapSize;
    }

    public void addAll(int[] objectIds, long usedHeapSize) {
        this.objectIds.addAll(objectIds);
        this.numberOfObjects += (long)objectIds.length;
        this.usedHeapSize += usedHeapSize;
    }

    public ClassHistogramRecord toClassHistogramRecord() {
        if (this.objectIds.length() > 0 && this.numberOfObjects != (long)this.objectIds.length()) {
            throw new RuntimeException("illegal use of class histogram record builder");
        }
        if (this.objectIds.length() > 0) {
            return new ClassHistogramRecord(this.getLabel(), this.classId, this.objectIds.toArray(), this.getUsedHeapSize(), this.getRetainedHeapSize());
        }
        return new ClassHistogramRecord(this.getLabel(), this.classId, this.getNumberOfObjects(), this.getUsedHeapSize(), this.getRetainedHeapSize());
    }
}

