/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplePathsFromGCRootsComputerImpl
implements IMultiplePathsFromGCRootsComputer {
    int[] objectIds;
    Object[] paths;
    SnapshotImpl snapshot;
    IIndexReader.IOne2ManyIndex inboundIndex;
    HashMapIntObject<?> roots;
    BitField excludeInstances;
    Map<IClass, Set<String>> excludeMap;
    boolean pathsCalculated;
    HashMapIntObject<Path> pathsCache = new HashMapIntObject(10000);

    public MultiplePathsFromGCRootsComputerImpl(int[] objectIds, Map<IClass, Set<String>> excludeMap, SnapshotImpl snapshot, HashMapIntObject<?> roots) throws SnapshotException {
        this.snapshot = snapshot;
        this.objectIds = objectIds;
        this.roots = roots;
        this.excludeMap = excludeMap;
        this.inboundIndex = snapshot.getIndexManager().inbound;
        if (excludeMap != null) {
            this.initExcludeInstances();
        }
    }

    private void initExcludeInstances() throws SnapshotException {
        this.excludeInstances = new BitField(this.snapshot.getIndexManager().o2address().size());
        for (IClass clazz : this.excludeMap.keySet()) {
            int[] objects;
            int[] nArray = objects = clazz.getObjectIds();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                int objId = nArray[n2];
                this.excludeInstances.set(objId);
                ++n2;
            }
        }
    }

    private void computePaths(IProgressListener progressListener) throws SnapshotException {
        int reportFrequency = Math.max(10, this.objectIds.length / 100);
        progressListener.beginTask("Finding paths", 100);
        ArrayList<int[]> pathsList = new ArrayList<int[]>();
        int i = 0;
        while (i < this.objectIds.length) {
            int[] path = this.getShortestPath(this.objectIds[i]);
            if (path != null) {
                pathsList.add(path);
            }
            if (progressListener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            if (i % reportFrequency == 0) {
                progressListener.worked(1);
            }
            ++i;
        }
        progressListener.done();
        this.pathsCalculated = true;
        this.paths = pathsList.toArray();
    }

    public MultiplePathsFromGCRootsRecord[] getPathsByGCRoot(IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        MultiplePathsFromGCRootsRecord dummy = new MultiplePathsFromGCRootsRecord(-1, -1, (ISnapshot)this.snapshot);
        int i = 0;
        while (i < this.paths.length) {
            dummy.addPath((int[])this.paths[i]);
            ++i;
        }
        return dummy.nextLevel();
    }

    public Object[] getAllPaths(IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        return this.paths;
    }

    public MultiplePathsFromGCRootsClassRecord[] getPathsGroupedByClass(boolean startFromTheGCRoots, IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, startFromTheGCRoots, (ISnapshot)this.snapshot);
        int i = 0;
        while (i < this.paths.length) {
            dummy.addPath((int[])this.paths[i]);
            ++i;
        }
        return dummy.nextLevel();
    }

    private int[] getShortestPath(int objectId) throws SnapshotException {
        LinkedList<Path> pathFifo = new LinkedList<Path>();
        LinkedList<int[]> referrersFifo = new LinkedList<int[]>();
        Path shortestPathToGCRoot = null;
        Path shortestPathToObject = null;
        int shortestDepth = Integer.MAX_VALUE;
        SetInt visited = new SetInt(1000);
        Path currentPath = null;
        if (this.roots.get(objectId) != null) {
            return new int[]{objectId};
        }
        pathFifo.add(null);
        referrersFifo.add(new int[]{objectId});
        while (pathFifo.size() > 0) {
            currentPath = (Path)pathFifo.getFirst();
            pathFifo.removeFirst();
            int[] currentReferrers = (int[])referrersFifo.getFirst();
            referrersFifo.removeFirst();
            int currentDepth = currentPath == null ? 0 : currentPath.depth;
            int i = 0;
            while (i < currentReferrers.length) {
                int referrer = currentReferrers[i];
                if (!(visited.contains(referrer) || this.excludeMap != null && currentPath != null && this.refersOnlyThroughExcluded(referrer, currentPath.objectId))) {
                    int[] nextReferrers = this.inboundIndex.get(referrer);
                    int j = 0;
                    while (j < nextReferrers.length) {
                        Path existingPath;
                        int nextReferrer = nextReferrers[j];
                        if (this.roots.get(nextReferrers[j]) != null) {
                            Path p1;
                            if (this.excludeMap == null) {
                                Path p;
                                p1 = new Path(referrer, null, currentPath);
                                if (currentPath != null) {
                                    currentPath.prev = p1;
                                }
                                p1.prev = p = new Path(nextReferrer, null, p1);
                                Path res = p;
                                int count = 1;
                                while (p != null) {
                                    p.depth = count++;
                                    this.pathsCache.put(p.objectId, (Object)p);
                                    Path q = p.next;
                                    if (q != null) {
                                        q.prev = p;
                                    }
                                    p = q;
                                }
                                return this.path2Int(res);
                            }
                            if (!this.refersOnlyThroughExcluded(nextReferrer, referrer)) {
                                Path p;
                                p1 = new Path(referrer, null, currentPath);
                                if (currentPath != null) {
                                    currentPath.prev = p1;
                                }
                                p1.prev = p = new Path(nextReferrer, null, p1);
                                Path res = p;
                                int count = 1;
                                while (p != null) {
                                    p.depth = count++;
                                    this.pathsCache.put(p.objectId, (Object)p);
                                    Path q = p.next;
                                    if (q != null) {
                                        q.prev = p;
                                    }
                                    p = q;
                                }
                                return this.path2Int(res);
                            }
                        }
                        if ((existingPath = (Path)this.pathsCache.get(nextReferrer)) != null) {
                            visited.add(nextReferrer);
                            if (existingPath.depth + currentDepth < shortestDepth) {
                                shortestDepth = existingPath.depth + currentDepth + 1;
                                shortestPathToGCRoot = existingPath;
                                shortestPathToObject = new Path(referrer, null, currentPath);
                            }
                        }
                        ++j;
                    }
                    visited.add(referrer);
                    Path newPath = new Path(referrer, null, currentPath);
                    pathFifo.addLast(newPath);
                    referrersFifo.addLast(nextReferrers);
                }
                ++i;
            }
            if (shortestPathToGCRoot == null || currentDepth + 1 < shortestDepth) continue;
            return this.joinPaths(shortestDepth, shortestPathToObject, shortestPathToGCRoot);
        }
        if (shortestPathToGCRoot != null) {
            return this.joinPaths(shortestDepth, shortestPathToObject, shortestPathToGCRoot);
        }
        return null;
    }

    private int[] joinPaths(int shortestDepth, Path shortestPathToObject, Path shortestPathToGCRoot) {
        int[] result = new int[shortestDepth];
        if (shortestPathToObject != null) {
            shortestPathToObject.prev = shortestPathToGCRoot;
        }
        int depthToGCRoot = shortestPathToGCRoot.depth;
        int depthToObject = shortestDepth - depthToGCRoot;
        int count = 1;
        while (shortestPathToObject != null) {
            shortestPathToObject.depth = depthToGCRoot + count;
            result[depthToObject - count] = shortestPathToObject.objectId;
            ++count;
            this.pathsCache.put(shortestPathToObject.objectId, (Object)shortestPathToObject);
            Path next = shortestPathToObject.next;
            if (next != null) {
                next.prev = shortestPathToObject;
            }
            shortestPathToObject = next;
        }
        while (shortestPathToGCRoot != null) {
            try {
                result[depthToObject++] = shortestPathToGCRoot.objectId;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(String.valueOf(depthToObject) + " ");
            }
            shortestPathToGCRoot = shortestPathToGCRoot.prev;
        }
        return result;
    }

    private boolean refersOnlyThroughExcluded(int referrerId, int referentId) throws SnapshotException {
        if (!this.excludeInstances.get(referrerId)) {
            return false;
        }
        IObject referrerObject = this.snapshot.getObject(referrerId);
        Set<String> excludeFields = this.excludeMap.get(referrerObject.getClazz());
        if (excludeFields == null) {
            return true;
        }
        long referentAddr = this.snapshot.mapIdToAddress(referentId);
        List refs = referrerObject.getOutboundReferences();
        for (NamedReference reference : refs) {
            if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
            return false;
        }
        return true;
    }

    private int[] path2Int(Path p) {
        IntStack s = new IntStack();
        while (p != null) {
            s.push(p.getObjectId());
            p = p.getNext();
        }
        int[] res = new int[s.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = s.pop();
            ++i;
        }
        return res;
    }

    class Path
    implements Cloneable {
        int objectId;
        int depth;
        Path next;
        Path prev;

        public Path(int index, Path prev, Path next) {
            this.objectId = index;
            this.next = next;
            this.prev = prev;
            this.depth = next == null ? 1 : next.depth + 1;
        }

        public Path getNext() {
            return this.next;
        }

        public int getObjectId() {
            return this.objectId;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean contains(long id) {
            Path p = this;
            while (p != null) {
                if ((long)p.objectId == id) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }

        public Path clone() {
            Path p = new Path(this.objectId, this.next, this.prev);
            return p;
        }
    }
}

