/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.List;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;

public class ObjectMarker {
    int[] roots;
    boolean[] bits;
    IIndexReader.IOne2ManyIndex outbound;
    IProgressListener progressListener;

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, IProgressListener progressListener) {
        this.roots = roots;
        this.bits = bits;
        this.outbound = outbound;
        this.progressListener = progressListener;
    }

    public int markSingleThreaded() throws IProgressListener.OperationCanceledException {
        int count = 0;
        int size = 0;
        int[] data = new int[10240];
        int rootsToProcess = 0;
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n2;
        }
        this.progressListener.beginTask("Calculate Retained Size", rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            int[] nArray2 = this.outbound.get(current);
            int n3 = nArray2.length;
            n = 0;
            while (n < n3) {
                int child = nArray2[n];
                if (!this.bits[child]) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    ++count;
                }
                ++n;
            }
        }
        this.progressListener.done();
        return count;
    }

    public int markSingleThreaded(ExcludedReferencesDescriptor[] excludeSets, ISnapshot snapshot) throws SnapshotException, IProgressListener.OperationCanceledException {
        int n;
        int n2;
        int[] nArray;
        BitField excludeObjectsBF = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n3 = excludeSets.length;
        int n4 = 0;
        while (n4 < n3) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n4];
            nArray = set.getObjectIds();
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int k = nArray[n];
                excludeObjectsBF.set(k);
                ++n;
            }
            ++n4;
        }
        int count = 0;
        int rootsToProcess = 0;
        int size = 0;
        int[] data = new int[10240];
        nArray = this.roots;
        n2 = this.roots.length;
        n = 0;
        while (n < n2) {
            int rootId = nArray[n];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n;
        }
        this.progressListener.beginTask("Calculate Retained Size", rootsToProcess);
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            int[] nArray2 = this.outbound.get(current);
            int n5 = nArray2.length;
            n2 = 0;
            while (n2 < n5) {
                int child = nArray2[n2];
                if (!this.bits[child] && !this.refersOnlyThroughExcluded(current, child, excludeSets, excludeObjectsBF, snapshot)) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    ++count;
                }
                ++n2;
            }
        }
        this.progressListener.done();
        return count;
    }

    public void markMultiThreaded(int numberOfThreads) throws InterruptedException {
        IntStack rootsStack = new IntStack(this.roots.length);
        int[] nArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            int rootId = nArray[n2];
            if (!this.bits[rootId]) {
                rootsStack.push(rootId);
                this.bits[rootId] = true;
            }
            ++n2;
        }
        this.progressListener.beginTask("Calculate Retained Size", rootsStack.size());
        DfsThread[] dfsthreads = new DfsThread[numberOfThreads];
        Thread[] threads = new Thread[numberOfThreads];
        int i = 0;
        while (i < numberOfThreads) {
            DfsThread dfsthread;
            dfsthreads[i] = dfsthread = new DfsThread(rootsStack);
            Thread thread = new Thread((Runnable)dfsthread, "ObjectMarkerThread-" + (i + 1));
            thread.start();
            threads[i] = thread;
            ++i;
        }
        i = 0;
        while (i < numberOfThreads) {
            threads[i].join();
            ++i;
        }
        if (this.progressListener.isCanceled()) {
            return;
        }
        this.progressListener.done();
    }

    private boolean refersOnlyThroughExcluded(int referrerId, int referentId, ExcludedReferencesDescriptor[] excludeSets, BitField excludeObjectsBF, ISnapshot snapshot) throws SnapshotException {
        if (!excludeObjectsBF.get(referrerId)) {
            return false;
        }
        IObject referrerObject = snapshot.getObject(referrerId);
        Set excludeFields = null;
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n = excludeSets.length;
        int n2 = 0;
        while (n2 < n) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n2];
            if (set.contains(referrerId)) {
                excludeFields = set.getFields();
                break;
            }
            ++n2;
        }
        if (excludeFields == null) {
            return true;
        }
        long referentAddr = snapshot.mapIdToAddress(referentId);
        List refs = referrerObject.getOutboundReferences();
        for (NamedReference reference : refs) {
            if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
            return false;
        }
        return true;
    }

    public class DfsThread
    implements Runnable {
        int size = 0;
        int[] data = new int[10240];
        IntStack rootsStack;

        public DfsThread(IntStack roots) {
            this.rootsStack = roots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                var1_1 = this.rootsStack;
                synchronized (var1_1) {
                    ObjectMarker.this.progressListener.worked(1);
                    if (ObjectMarker.this.progressListener.isCanceled()) {
                        return;
                    }
                    if (this.rootsStack.size() <= 0) {
                        break;
                    }
                    this.data[0] = this.rootsStack.pop();
                    this.size = 1;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl32
                }
                do {
                    current = this.data[--this.size];
                    var5_6 = ObjectMarker.this.outbound.get(current);
                    var4_5 = var5_6.length;
                    var3_4 = 0;
                    while (var3_4 < var4_5) {
                        child = var5_6[var3_4];
                        if (!ObjectMarker.this.bits[child]) {
                            ObjectMarker.this.bits[child] = true;
                            if (this.size == this.data.length) {
                                newArr = new int[this.data.length << 1];
                                System.arraycopy(this.data, 0, newArr, 0, this.data.length);
                                this.data = newArr;
                            }
                            this.data[this.size++] = child;
                        }
                        ++var3_4;
                    }
lbl32:
                    // 2 sources

                } while (this.size > 0);
            }
        }
    }
}

