/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.RegistryReader;
import org.eclipse.mat.util.SimpleStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry
extends RegistryReader<Parser> {
    public static final String INDEX_BUILDER = "indexBuilder";
    public static final String OBJECT_READER = "objectReader";

    public ParserRegistry(IExtensionTracker tracker) {
        this.init(tracker, "org.eclipse.mat.parser.parser");
    }

    public Parser createDelegate(IConfigurationElement configElement) {
        String fileExtensions = configElement.getAttribute("fileExtension");
        if (fileExtensions == null || fileExtensions.length() == 0) {
            return null;
        }
        try {
            String[] extensions = SimpleStringTokenizer.split((String)fileExtensions, (char)',');
            Pattern[] patterns = new Pattern[extensions.length];
            int ii = 0;
            while (ii < extensions.length) {
                patterns[ii] = Pattern.compile("(.*\\.)((?i)" + extensions[ii] + ")(\\.[0-9]*)?");
                ++ii;
            }
            SnapshotFormat snapshotFormat = new SnapshotFormat(configElement.getAttribute("name"), extensions);
            return new Parser(configElement, snapshotFormat, patterns);
        }
        catch (PatternSyntaxException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, MessageFormat.format("Error compiling file name pattern of extension {0}", configElement.getNamespaceIdentifier()), e);
            return null;
        }
    }

    protected void removeDelegate(Parser delegate) {
    }

    public Parser lookupParser(String uniqueIdentifier) {
        for (Parser p : this.delegates()) {
            if (!uniqueIdentifier.equals(p.getUniqueIdentifier())) continue;
            return p;
        }
        return null;
    }

    public List<Parser> matchParser(String fileName) {
        ArrayList<Parser> answer = new ArrayList<Parser>();
        for (Parser p : this.delegates()) {
            Pattern[] patternArray = p.pattern;
            int n = patternArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern regex = patternArray[n2];
                if (regex.matcher(fileName).matches()) {
                    answer.add(p);
                }
                ++n2;
            }
        }
        return answer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Parser {
        private String id;
        private IConfigurationElement configElement;
        private SnapshotFormat snapshotFormat;
        private Pattern[] pattern;

        private Parser(IConfigurationElement configElement, SnapshotFormat snapshotFormat, Pattern[] pattern) {
            this.id = ((IExtension)configElement.getParent()).getSimpleIdentifier();
            this.configElement = configElement;
            this.snapshotFormat = snapshotFormat;
            this.pattern = pattern;
        }

        public String getId() {
            return this.id;
        }

        public String getUniqueIdentifier() {
            IExtension extension = (IExtension)this.configElement.getParent();
            return extension.getUniqueIdentifier();
        }

        public SnapshotFormat getSnapshotFormat() {
            return this.snapshotFormat;
        }

        public <I> I create(Class<I> type, String attribute) {
            try {
                return (I)this.configElement.createExecutableExtension(attribute);
            }
            catch (CoreException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format("Error while creating {0} ''{1}''", type.getSimpleName(), this.configElement.getAttribute("addonBuilder")), e);
                return null;
            }
        }
    }
}

