/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import java.text.MessageFormat;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.util.IProgressListener;

public abstract class ContextDerivedData {
    public abstract DerivedColumn[] getDerivedColumns();

    public abstract String labelFor(DerivedColumn var1, ContextProvider var2);

    public abstract Column columnFor(DerivedColumn var1, IResult var2, ContextProvider var3);

    public final DerivedColumn lookup(DerivedOperation operation) {
        DerivedColumn[] derivedColumnArray = this.getDerivedColumns();
        int n = derivedColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            DerivedColumn column = derivedColumnArray[n2];
            DerivedOperation[] derivedOperationArray = column.getOperations();
            int n3 = derivedOperationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                DerivedOperation oo = derivedOperationArray[n4];
                if (oo == operation) {
                    return column;
                }
                ++n4;
            }
            ++n2;
        }
        throw new RuntimeException(MessageFormat.format("Mismatch: Operation ''{0}'' not found in ''{1}''", operation.getLabel(), this.getClass().getName()));
    }

    public static interface DerivedCalculator {
        public Object lookup(Object var1);

        public void calculate(DerivedOperation var1, Object var2, IProgressListener var3) throws SnapshotException;
    }

    public static final class DerivedColumn {
        private final String label;
        private final DerivedOperation[] operations;

        public DerivedColumn(String label, DerivedOperation ... operations) {
            this.label = label;
            this.operations = operations;
        }

        public String getLabel() {
            return this.label;
        }

        public DerivedOperation[] getOperations() {
            return this.operations;
        }
    }

    public static final class DerivedOperation {
        private final String code;
        private final String label;

        public DerivedOperation(String code, String label) {
            this.code = code;
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

