/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TotalsRow {
    private static final URL SUM = TotalsRow.class.getResource("/META-INF/icons/misc/sum.gif");
    private static final URL SUM_PLUS = TotalsRow.class.getResource("/META-INF/icons/misc/sum_plus.gif");
    private static final NumberFormat fmt = DecimalFormat.getInstance();
    private Double[] totals;
    private int filteredItems;
    private int numberOfItems;
    private int visibleItems;

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        this.visibleItems = visibleItems;
    }

    public int getFilteredItems() {
        return this.filteredItems;
    }

    void setFilteredItems(int filteredItems) {
        this.filteredItems = filteredItems;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    void setNumberOfItems(int numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    void setTotals(Double[] totals) {
        this.totals = totals;
    }

    public URL getIcon() {
        return this.visibleItems < this.numberOfItems ? SUM_PLUS : SUM;
    }

    public boolean isVisible() {
        return this.numberOfItems > 1 || this.filteredItems > 0 || this.visibleItems < this.numberOfItems;
    }

    public String getLabel(int columnIndex) {
        if (columnIndex == 0) {
            return this.getFirstItemText();
        }
        if (this.totals == null) {
            return "";
        }
        if (columnIndex < 1 || columnIndex >= this.totals.length) {
            return "";
        }
        if (this.totals[columnIndex] == null) {
            return "";
        }
        return fmt.format(this.totals[columnIndex]);
    }

    private String getFirstItemText() {
        Double total;
        NumberFormat fmt = DecimalFormat.getInstance();
        StringBuilder buf = new StringBuilder();
        buf.append("Total: ");
        if (this.numberOfItems > this.visibleItems) {
            buf.append(fmt.format(this.visibleItems)).append(" of ");
        }
        buf.append(fmt.format(this.numberOfItems));
        buf.append(this.numberOfItems == 1 ? " entry" : " entries");
        if (this.numberOfItems > this.visibleItems) {
            buf.append(" displayed");
        }
        if (this.totals != null && (total = this.totals[0]) != null) {
            buf.append(" / ").append(fmt.format(total));
        }
        if (this.filteredItems > 0) {
            buf.append(" (").append(fmt.format(this.filteredItems)).append(" filtered)");
        }
        return buf.toString();
    }
}

