/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.query.registry.Converters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentDescriptor {
    private boolean isMandatory;
    private String name;
    private String flag;
    private String help;
    private Field field;
    private boolean isArray;
    private boolean isList;
    private Class<?> type;
    private Argument.Advice advice;
    private Object defaultValue;

    public boolean isMultiple() {
        return this.isArray || this.isList;
    }

    public boolean isBoolean() {
        return this.type == Boolean.class || this.type == Boolean.TYPE;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
    }

    public String getFlag() {
        return this.flag;
    }

    void setFlag(String flag) {
        this.flag = flag;
    }

    public boolean isArray() {
        return this.isArray;
    }

    void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public boolean isList() {
        return this.isList;
    }

    void setList(boolean isList) {
        this.isList = isList;
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    void setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    void setType(Class<?> type) {
        this.type = type;
    }

    public String getHelp() {
        return this.help;
    }

    void setHelp(String help) {
        this.help = help;
    }

    public Argument.Advice getAdvice() {
        return this.advice;
    }

    void setAdvice(Argument.Advice advice) {
        this.advice = advice;
    }

    public String toString() {
        return new StringBuilder(256).append(this.name).append("(isRequired=").append(this.isMandatory).append(",flag=").append(this.flag).append(",type=").append(this.type.getName()).append(")").toString();
    }

    void appendUsage(StringBuilder buf) {
        buf.append(" ");
        if (!this.isMandatory()) {
            buf.append("[");
        }
        if (this.flag != null) {
            buf.append("-").append(this.flag);
        }
        if (this.isMultiple()) {
            if (this.flag != null) {
                buf.append(" ");
            }
            buf.append("<").append(this.name).append("0 .. N>");
        } else if (!this.isBoolean()) {
            if (this.flag != null) {
                buf.append(" ");
            }
            buf.append("<").append(this.name).append(">");
        }
        if (!this.isMandatory()) {
            buf.append("]");
        }
    }

    void appendUsage(StringBuilder buf, Object value) {
        if (value instanceof ArgumentFactory) {
            ((ArgumentFactory)value).appendUsage(buf);
            return;
        }
        if (this.isMultiple() && (value == null || ((List)value).isEmpty())) {
            return;
        }
        buf.append(" ");
        if (this.isBoolean()) {
            if (value != null && ((Boolean)value).booleanValue()) {
                buf.append("-").append(this.flag);
            }
        } else {
            if (this.flag != null) {
                buf.append("-").append(this.flag).append(" ");
            }
            if (value == null) {
                buf.append("\"\"");
            } else if (this.isMultiple()) {
                List values = (List)value;
                for (Object v : values) {
                    buf.append(v == null ? "\"\"" : Converters.convertAndEscape(this.type, v)).append(" ");
                }
            } else {
                buf.append(Converters.convertAndEscape(this.type, value));
            }
        }
    }
}

