/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentSet {
    private IQueryContext context;
    private QueryDescriptor query;
    private Map<ArgumentDescriptor, Object> values;

    ArgumentSet(QueryDescriptor query, IQueryContext context) {
        this.query = query;
        this.values = new HashMap<ArgumentDescriptor, Object>();
        for (ArgumentDescriptor argument : query.getArguments()) {
            if (!context.available(argument.getType(), argument.getAdvice())) continue;
            this.values.put(argument, context.get(argument.getType(), argument.getAdvice()));
        }
        this.context = context;
    }

    public QueryResult execute(IProgressListener listener) throws SnapshotException, SnapshotException {
        try {
            IQuery impl = this.query.getCommandType().newInstance();
            for (ArgumentDescriptor parameter : this.query.getArguments()) {
                Object value = this.values.get(parameter);
                if (value == null && parameter.isMandatory() && (value = parameter.getDefaultValue()) == null) {
                    throw new SnapshotException(MessageFormat.format("Missing required parameter: {0}", parameter.getName()));
                }
                if (value == null) {
                    if (!this.values.containsKey(parameter)) continue;
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Setting null value for: " + parameter.getName());
                    parameter.getField().set(impl, null);
                    continue;
                }
                try {
                    if (value instanceof ArgumentFactory) {
                        parameter.getField().set(impl, ((ArgumentFactory)value).build(parameter));
                        continue;
                    }
                    if (parameter.isArray()) {
                        List list = (List)value;
                        Object array = Array.newInstance(parameter.getType(), list.size());
                        int ii = 0;
                        for (Object v : list) {
                            Array.set(array, ii++, v);
                        }
                        parameter.getField().set(impl, array);
                        continue;
                    }
                    parameter.getField().set(impl, value);
                }
                catch (IllegalArgumentException e) {
                    throw new SnapshotException(MessageFormat.format("Illegal argument: {0} of type {1} cannot be set to field {2} of type {3}", value, value.getClass().getName(), parameter.getName(), parameter.getType().getName()), e);
                }
                catch (IllegalAccessException e) {
                    throw new SnapshotException(MessageFormat.format("Unable to access field {0} of type {1}", parameter.getName(), parameter.getType().getName()), e);
                }
            }
            IResult result = impl.execute(listener);
            return new QueryResult(this.query, this.writeToLine(), result);
        }
        catch (InstantiationException e) {
            throw new SnapshotException("Unable to instantiate command " + this.query.getCommandType().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SnapshotException("Unable to set field of " + this.query.getCommandType().getName(), e);
        }
        catch (IProgressListener.OperationCanceledException e) {
            throw e;
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow(e);
        }
    }

    public String writeToLine() {
        StringBuilder answer = new StringBuilder(128);
        answer.append(this.query.getIdentifier()).append(" ");
        for (ArgumentDescriptor arg : this.query.getArguments()) {
            Object value = this.values.get(arg);
            if (value == null && !this.values.containsKey(arg) || this.context.available(arg.getType(), arg.getAdvice()) || this.context.available(arg.getType(), arg.getAdvice())) continue;
            if (value != null) {
                arg.appendUsage(answer, value);
                continue;
            }
            if (arg.getDefaultValue() != null) {
                arg.appendUsage(answer, null);
                continue;
            }
            if (!arg.isMandatory() || arg.getDefaultValue() == null) continue;
            arg.appendUsage(answer, arg.getDefaultValue());
        }
        return answer.toString().trim();
    }

    public void setArgumentValue(ArgumentDescriptor arg, Object value) {
        this.values.put(arg, value);
    }

    public void setArgumentValue(String name, Object value) {
        ArgumentDescriptor argument = this.query.getArgumentByName(name);
        if (argument == null) {
            throw new RuntimeException(MessageFormat.format("Query ''{0}'' has no argument named ''{1}''", this.query.getIdentifier(), name));
        }
        this.setArgumentValue(argument, value);
    }

    public void removeArgumentValue(ArgumentDescriptor arg) {
        this.values.remove(arg);
    }

    public Object getArgumentValue(ArgumentDescriptor desc) {
        return this.values.get(desc);
    }

    public QueryDescriptor getQueryDescriptor() {
        return this.query;
    }

    IQueryContext getQueryContext() {
        return this.context;
    }

    public boolean isExecutable() {
        for (ArgumentDescriptor parameter : this.query.getArguments()) {
            if (!parameter.isMandatory() || this.values.containsKey(parameter) || parameter.getDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    public List<ArgumentDescriptor> getUnsetArguments() {
        ArrayList<ArgumentDescriptor> answer = new ArrayList<ArgumentDescriptor>();
        for (ArgumentDescriptor parameter : this.query.getArguments()) {
            if (this.values.containsKey(parameter)) continue;
            answer.add(parameter);
        }
        return answer;
    }

    public String getUnsetUsage() {
        StringBuilder answer = new StringBuilder(128);
        for (ArgumentDescriptor parameter : this.query.getArguments()) {
            if (this.context.available(parameter.getType(), parameter.getAdvice()) || this.values.containsKey(parameter)) continue;
            parameter.appendUsage(answer);
        }
        return answer.toString().trim();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.query);
        if (!this.values.isEmpty()) {
            for (Map.Entry<ArgumentDescriptor, Object> entry : this.values.entrySet()) {
                buf.append(" ").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
        }
        return buf.toString();
    }
}

