/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionSpec
extends Spec {
    private ITestResult.Status status;
    private List<Spec> children = new ArrayList<Spec>();

    @Deprecated
    public SectionSpec() {
    }

    public SectionSpec(String name) {
        super(name);
    }

    public ITestResult.Status getStatus() {
        return this.status;
    }

    public void setStatus(ITestResult.Status status) {
        this.status = status;
    }

    public List<Spec> getChildren() {
        return this.children;
    }

    public void add(Spec child) {
        this.children.add(child);
    }

    @Override
    public synchronized void merge(Spec otherSpec) {
        if (!(otherSpec instanceof SectionSpec)) {
            throw new RuntimeException(MessageFormat.format("Incompatible types: {0} and {1}", otherSpec.getName(), this.getName()));
        }
        super.merge(otherSpec);
        SectionSpec other = (SectionSpec)otherSpec;
        this.status = ITestResult.Status.max(this.status, other.status);
        if (this.children.isEmpty()) {
            this.children.addAll(other.children);
        } else if (!other.children.isEmpty()) {
            HashMap<String, Spec> name2spec = new HashMap<String, Spec>();
            for (Spec child : this.children) {
                name2spec.put(child.getName(), child);
            }
            ArrayList<Spec> merged = new ArrayList<Spec>();
            for (Spec spec : other.children) {
                Spec mine = (Spec)name2spec.get(spec.getName());
                if (mine != null) {
                    mine.merge(spec);
                    merged.add(mine);
                    this.children.remove(mine);
                    continue;
                }
                merged.add(spec);
            }
            merged.addAll(this.children);
            this.children = merged;
        }
    }
}

